/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.vec.Vector3;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemUtils {
    public static boolean isPlayerHolding(LivingEntity entity, Predicate<Item> predicate) {
        for (Hand hand : Hand.values()) {
            ItemStack stack = entity.func_184586_b(hand);
            if (stack.func_190926_b() || !predicate.test(stack.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerHoldingSomething(PlayerEntity player) {
        return !player.func_184614_ca().func_190926_b() || !player.func_184592_cb().func_190926_b();
    }

    @Nonnull
    public static ItemStack getHeldStack(PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            stack = player.func_184592_cb();
        }
        return stack;
    }

    public static void dropItem(ItemStack stack, World world, Vector3 dropLocation) {
        ItemEntity item = new ItemEntity(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.func_213293_j(world.field_73012_v.nextGaussian() * 0.05, world.field_73012_v.nextGaussian() * 0.05 + (double)0.2f, world.field_73012_v.nextGaussian() * 0.05);
        world.func_217376_c((Entity)item);
    }

    public static void dropItem(World world, BlockPos pos, @Nonnull ItemStack stack, double velocity) {
        double xVelocity = (double)world.field_73012_v.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        double yVelocity = (double)world.field_73012_v.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        double zVelocity = (double)world.field_73012_v.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        ItemEntity entityItem = new ItemEntity(world, (double)pos.func_177958_n() + xVelocity, (double)pos.func_177956_o() + yVelocity, (double)pos.func_177952_p() + zVelocity, stack);
        entityItem.func_174867_a(10);
        world.func_217376_c((Entity)entityItem);
    }

    public static void dropItem(World world, BlockPos pos, @Nonnull ItemStack stack) {
        ItemUtils.dropItem(world, pos, stack, 0.7);
    }

    public static void dropInventory(World world, BlockPos pos, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_190916_E() <= 0) continue;
            ItemUtils.dropItem(world, pos, stack);
        }
    }

    public static ItemStack copyStack(@Nonnull ItemStack stack, int quantity) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        stack = stack.func_77946_l();
        stack.func_190920_e(quantity);
        return stack;
    }

    public static void ejectItem(World world, BlockPos pos, @Nonnull ItemStack stack, Direction dir) {
        pos.func_177972_a(dir);
        ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        entity.func_213317_d(new Vec3d(dir.func_176730_m()).func_186678_a(0.3));
        entity.func_174867_a(10);
        world.func_217376_c((Entity)entity);
    }

    public static void ejectItems(World world, BlockPos pos, List<ItemStack> stacks, Direction dir) {
        for (ItemStack stack : stacks) {
            ItemUtils.ejectItem(world, pos, stack, dir);
        }
    }

    @Deprecated
    public static int getBurnTime(@Nonnull ItemStack itemStack) {
        return ForgeHooks.getBurnTime((ItemStack)itemStack);
    }

    public static int compareItemStack(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        int itemStack2ID;
        int itemStack1ID = Item.func_150891_b((Item)stack1.func_77973_b());
        return itemStack1ID != (itemStack2ID = Item.func_150891_b((Item)stack1.func_77973_b())) ? itemStack1ID - itemStack2ID : (stack1.func_77952_i() == stack2.func_77952_i() ? 0 : stack1.func_77952_i() - stack2.func_77952_i());
    }

    public static boolean areStacksSameType(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && stack1.func_77973_b() == stack2.func_77973_b() && stack2.func_77952_i() == stack1.func_77952_i() && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1);
    }

    public static boolean tagsMatch(Item item1, Item item2) {
        Set tag1 = item1.getTags();
        Set tag2 = item2.getTags();
        return tag1.stream().anyMatch(tag2::contains);
    }

    public static boolean areStacksSameOrTagged(ItemStack stack1, ItemStack stack2) {
        return ItemUtils.areStacksSameType(stack1, stack2) || ItemUtils.tagsMatch(stack1.func_77973_b(), stack2.func_77973_b());
    }
}

