/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl.client;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lain.mods.cos.impl.ModConfigs;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.client.PlayerRenderHandler;
import lain.mods.cos.impl.client.gui.GuiCosArmorButton;
import lain.mods.cos.impl.client.gui.GuiCosArmorInventory;
import lain.mods.cos.impl.client.gui.GuiCosArmorToggleButton;
import lain.mods.cos.impl.client.gui.IShiftingWidget;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import lain.mods.cos.impl.network.packet.PacketOpenCosArmorInventory;
import lain.mods.cos.impl.network.packet.PacketOpenNormalInventory;
import lain.mods.cos.impl.network.packet.PacketSetHiddenFlags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.inventory.SlotCurio;
import top.theillusivec4.curios.common.inventory.CuriosContainer;

public enum GuiHandler {
    INSTANCE;

    private static final boolean isCuriosLoaded;
    public static final Set<Integer> ButtonIds;
    private Consumer<Object> currentWidgetAdder = null;
    private Consumer<Object> currentWidgetRemover = null;
    private Optional<Field> fieldaccess_curioscontainer_lastscrollindex;
    private Optional<Field> fieldaccess_slotcurio_identifier;
    private int lastLeft = 0;
    private int lastCuriosScrollIndex = -1;

    private void handleGuiDrawPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (event.getGui() instanceof ContainerScreen) {
            ContainerScreen screen = (ContainerScreen)event.getGui();
            if (this.lastLeft != screen.field_147003_i) {
                int diffLeft = screen.field_147003_i - this.lastLeft;
                this.lastLeft = screen.field_147003_i;
                screen.buttons.stream().filter(IShiftingWidget.class::isInstance).forEach(b -> b.x += diffLeft);
            }
            if (isCuriosLoaded) {
                Container container;
                if (this.fieldaccess_curioscontainer_lastscrollindex == null) {
                    try {
                        Field f = CuriosContainer.class.getDeclaredField("lastScrollIndex");
                        f.setAccessible(true);
                        this.fieldaccess_curioscontainer_lastscrollindex = Optional.of(f);
                    }
                    catch (Throwable e) {
                        ModObjects.logger.error("Failed in acquiring fieldaccess_curioscontainer_lastscrollindex", e);
                        this.fieldaccess_curioscontainer_lastscrollindex = Optional.empty();
                    }
                }
                if (this.fieldaccess_slotcurio_identifier == null) {
                    try {
                        Field f = SlotCurio.class.getDeclaredField("identifier");
                        f.setAccessible(true);
                        this.fieldaccess_slotcurio_identifier = Optional.of(f);
                    }
                    catch (Throwable e) {
                        ModObjects.logger.error("Failed in acquiring fieldaccess_slotcurio_identifier", e);
                        this.fieldaccess_slotcurio_identifier = Optional.empty();
                    }
                }
                if (this.fieldaccess_curioscontainer_lastscrollindex.isPresent() && this.fieldaccess_slotcurio_identifier.isPresent() && (container = screen.func_212873_a_()) instanceof CuriosContainer) {
                    try {
                        int index = (Integer)this.fieldaccess_curioscontainer_lastscrollindex.get().get(container);
                        if (this.lastCuriosScrollIndex == -1 || this.lastCuriosScrollIndex != index) {
                            this.lastCuriosScrollIndex = index;
                            screen.buttons.stream().filter(GuiCosArmorToggleButton.class::isInstance).map(GuiCosArmorToggleButton.class::cast).filter(button -> button.stamp == 1).collect(Collectors.toList()).forEach(this.currentWidgetRemover);
                            Minecraft mc = (Minecraft)LogicalSidedProvider.INSTANCE.get(LogicalSide.CLIENT);
                            InventoryCosArmor invCosArmor = ModObjects.invMan.getCosArmorInventoryClient(mc.field_71439_g.func_110124_au());
                            for (Slot slot : container.field_75151_b) {
                                if (!(slot instanceof SlotCurio)) continue;
                                String identifier = (String)this.fieldaccess_slotcurio_identifier.get().get(slot) + "#" + slot.getSlotIndex();
                                this.currentWidgetAdder.accept(new GuiCosArmorToggleButton(screen.field_147003_i + slot.field_75223_e - 1, screen.field_147009_r + slot.field_75221_f - 1, 5, 5, "", invCosArmor.isHidden("curios", identifier) ? 1 : 0, button -> {
                                    invCosArmor.setHidden("curios", identifier, !invCosArmor.isHidden("curios", identifier));
                                    ((GuiCosArmorToggleButton)button).state = invCosArmor.isHidden("curios", identifier) ? 1 : 0;
                                    ModObjects.network.sendToServer(new PacketSetHiddenFlags("curios", identifier, invCosArmor.isHidden("curios", identifier)));
                                }).setStamp(1));
                            }
                        }
                    }
                    catch (Throwable e) {
                        ModObjects.logger.fatal("Failed in adding toggleable buttons to CurioSlots", e);
                        this.fieldaccess_curioscontainer_lastscrollindex = Optional.empty();
                        this.fieldaccess_slotcurio_identifier = Optional.empty();
                    }
                }
            }
        }
    }

    private void handleGuiInitPost(GuiScreenEvent.InitGuiEvent.Post event) {
        ContainerScreen screen;
        this.currentWidgetAdder = obj -> event.addWidget((Widget)obj);
        this.currentWidgetRemover = obj -> event.removeWidget((Widget)obj);
        if (event.getGui() instanceof ContainerScreen) {
            screen = (ContainerScreen)event.getGui();
            this.lastLeft = screen.field_147003_i;
            if (isCuriosLoaded) {
                this.lastCuriosScrollIndex = -1;
            }
        }
        if (event.getGui() instanceof InventoryScreen || event.getGui() instanceof GuiCosArmorInventory) {
            screen = (ContainerScreen)event.getGui();
            if (!((Boolean)ModConfigs.CosArmorGuiButton_Hidden.get()).booleanValue()) {
                event.addWidget((Widget)new GuiCosArmorButton(screen.field_147003_i + (Integer)ModConfigs.CosArmorGuiButton_Left.get(), screen.field_147009_r + (Integer)ModConfigs.CosArmorGuiButton_Top.get(), 10, 10, event.getGui() instanceof GuiCosArmorInventory ? "cos.gui.buttonnormal" : "cos.gui.buttoncos", button -> {
                    if (screen instanceof GuiCosArmorInventory) {
                        InventoryScreen newGui = new InventoryScreen((PlayerEntity)screen.getMinecraft().field_71439_g);
                        newGui.field_147048_u = ((GuiCosArmorInventory)screen).oldMouseX;
                        newGui.field_147047_v = ((GuiCosArmorInventory)screen).oldMouseY;
                        screen.getMinecraft().func_147108_a((Screen)newGui);
                        ModObjects.network.sendToServer(new PacketOpenNormalInventory());
                    } else {
                        ModObjects.network.sendToServer(new PacketOpenCosArmorInventory());
                    }
                }));
            }
            if (!((Boolean)ModConfigs.CosArmorToggleButton_Hidden.get()).booleanValue()) {
                event.addWidget((Widget)new GuiCosArmorToggleButton(screen.field_147003_i + (Integer)ModConfigs.CosArmorToggleButton_Left.get(), screen.field_147009_r + (Integer)ModConfigs.CosArmorToggleButton_Top.get(), 5, 5, "", PlayerRenderHandler.Disabled ? 1 : 0, button -> {
                    PlayerRenderHandler.Disabled = !PlayerRenderHandler.Disabled;
                    ((GuiCosArmorToggleButton)button).state = PlayerRenderHandler.Disabled ? 1 : 0;
                }));
            }
        }
    }

    public void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(this::handleGuiDrawPre);
        MinecraftForge.EVENT_BUS.addListener(this::handleGuiInitPost);
        this.setupGuiFactory();
    }

    private void setupGuiFactory() {
        ScreenManager.func_216911_a(ModObjects.typeContainerCosArmor, GuiCosArmorInventory::new);
    }

    static {
        isCuriosLoaded = ModList.get().isLoaded("curios");
        ButtonIds = ImmutableSet.of((Object)76, (Object)77);
    }
}

