/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.api.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.RSMode;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;

public abstract class AbstractConnectorSettings
implements IConnectorSettings {
    public static final String TAG_RS = "rs";
    public static final String TAG_COLOR = "color";
    public static final String TAG_FACING = "facing";
    private RSMode rsMode = RSMode.IGNORED;
    private int prevPulse = 0;
    private Color[] colors = new Color[]{Color.OFF, Color.OFF, Color.OFF, Color.OFF};
    private int colorsMask = 0;
    protected boolean advanced = false;
    @Nonnull
    private final Direction side;
    @Nullable
    private Direction facingOverride = null;

    public AbstractConnectorSettings(@Nonnull Direction side) {
        this.side = side;
    }

    @Nonnull
    public Direction getFacing() {
        return this.facingOverride == null ? this.side : this.facingOverride;
    }

    public RSMode getRsMode() {
        return this.rsMode;
    }

    public int getPrevPulse() {
        return this.prevPulse;
    }

    public void setPrevPulse(int prevPulse) {
        this.prevPulse = prevPulse;
    }

    public Color[] getColors() {
        return this.colors;
    }

    private void calculateColorsMask() {
        this.colorsMask = 0;
        for (Color color : this.colors) {
            if (color == null || color == Color.OFF) continue;
            this.colorsMask |= 1 << color.ordinal();
        }
    }

    public int getColorsMask() {
        return this.colorsMask;
    }

    public void update(Map<String, Object> data) {
        this.rsMode = data.containsKey(TAG_RS) ? RSMode.valueOf((String)((String)data.get(TAG_RS)).toUpperCase()) : RSMode.IGNORED;
        this.colors[0] = data.containsKey("color0") ? Color.colorByValue((int)((Integer)data.get("color0"))) : Color.OFF;
        this.colors[1] = data.containsKey("color1") ? Color.colorByValue((int)((Integer)data.get("color1"))) : Color.OFF;
        this.colors[2] = data.containsKey("color2") ? Color.colorByValue((int)((Integer)data.get("color2"))) : Color.OFF;
        this.colors[3] = data.containsKey("color3") ? Color.colorByValue((int)((Integer)data.get("color3"))) : Color.OFF;
        this.calculateColorsMask();
        String facing = (String)data.get(TAG_FACING);
        this.facingOverride = facing == null ? null : Direction.func_176739_a((String)facing);
    }

    protected static <T extends Enum<T>> void setEnumSafe(JsonObject object, String tag, T value) {
        if (value != null) {
            object.add(tag, (JsonElement)new JsonPrimitive(value.name()));
        }
    }

    protected static <T extends Enum<T>> T getEnumSafe(JsonObject object, String tag, Function<String, T> translator) {
        if (object.has(tag)) {
            return (T)((Enum)translator.apply(object.get(tag).getAsString()));
        }
        return null;
    }

    protected static void setIntegerSafe(JsonObject object, String tag, Integer value) {
        if (value != null) {
            object.add(tag, (JsonElement)new JsonPrimitive((Number)value));
        }
    }

    protected static Integer getIntegerSafe(JsonObject object, String tag) {
        if (object.has(tag)) {
            return object.get(tag).getAsInt();
        }
        return null;
    }

    protected static int getIntegerNotNull(JsonObject object, String tag) {
        if (object.has(tag)) {
            return object.get(tag).getAsInt();
        }
        return 0;
    }

    protected static boolean getBoolSafe(JsonObject object, String tag) {
        if (object.has(tag)) {
            return object.get(tag).getAsBoolean();
        }
        return false;
    }

    protected void writeToJsonInternal(JsonObject object) {
        AbstractConnectorSettings.setEnumSafe(object, "rsmode", this.rsMode);
        AbstractConnectorSettings.setEnumSafe(object, "color0", this.colors[0]);
        AbstractConnectorSettings.setEnumSafe(object, "color1", this.colors[1]);
        AbstractConnectorSettings.setEnumSafe(object, "color2", this.colors[2]);
        AbstractConnectorSettings.setEnumSafe(object, "color3", this.colors[3]);
        AbstractConnectorSettings.setEnumSafe(object, "side", this.side);
        AbstractConnectorSettings.setEnumSafe(object, "facingoverride", this.facingOverride);
        object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
    }

    protected void readFromJsonInternal(JsonObject object) {
        this.rsMode = AbstractConnectorSettings.getEnumSafe(object, "rsmode", EnumStringTranslators::getRSMode);
        this.colors[0] = AbstractConnectorSettings.getEnumSafe(object, "color0", EnumStringTranslators::getColor);
        this.colors[1] = AbstractConnectorSettings.getEnumSafe(object, "color1", EnumStringTranslators::getColor);
        this.colors[2] = AbstractConnectorSettings.getEnumSafe(object, "color2", EnumStringTranslators::getColor);
        this.colors[3] = AbstractConnectorSettings.getEnumSafe(object, "color3", EnumStringTranslators::getColor);
        this.facingOverride = AbstractConnectorSettings.getEnumSafe(object, "facingoverride", Direction::func_176739_a);
    }

    public void readFromNBT(CompoundNBT tag) {
        this.rsMode = RSMode.values()[tag.func_74771_c("rsMode")];
        this.prevPulse = tag.func_74762_e("prevPulse");
        this.colors[0] = Color.values()[tag.func_74771_c("color0")];
        this.colors[1] = Color.values()[tag.func_74771_c("color1")];
        this.colors[2] = Color.values()[tag.func_74771_c("color2")];
        this.colors[3] = Color.values()[tag.func_74771_c("color3")];
        this.calculateColorsMask();
        if (tag.func_74764_b("facingOverride")) {
            this.facingOverride = OrientationTools.DIRECTION_VALUES[tag.func_74771_c("facingOverride")];
        }
    }

    public void writeToNBT(CompoundNBT tag) {
        tag.func_74774_a("rsMode", (byte)this.rsMode.ordinal());
        tag.func_74768_a("prevPulse", this.prevPulse);
        tag.func_74774_a("color0", (byte)this.colors[0].ordinal());
        tag.func_74774_a("color1", (byte)this.colors[1].ordinal());
        tag.func_74774_a("color2", (byte)this.colors[2].ordinal());
        tag.func_74774_a("color3", (byte)this.colors[3].ordinal());
        if (this.facingOverride != null) {
            tag.func_74774_a("facingOverride", (byte)this.facingOverride.ordinal());
        }
    }

    protected IEditorGui sideGui(IEditorGui gui) {
        return gui.choices(TAG_FACING, "Side from which to operate", (Enum)(this.facingOverride == null ? this.side : this.facingOverride), (Enum[])OrientationTools.DIRECTION_VALUES);
    }

    protected IEditorGui colorsGui(IEditorGui gui) {
        return gui.colors("color0", "Enable on color", Integer.valueOf(this.colors[0].getColor()), Color.COLORS).colors("color1", "Enable on color", Integer.valueOf(this.colors[1].getColor()), Color.COLORS).colors("color2", "Enable on color", Integer.valueOf(this.colors[2].getColor()), Color.COLORS).colors("color3", "Enable on color", Integer.valueOf(this.colors[3].getColor()), Color.COLORS);
    }

    protected IEditorGui redstoneGui(IEditorGui gui) {
        return gui.redstoneMode(TAG_RS, this.rsMode);
    }
}

