/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.facade.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.xnet.XNet;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.modules.facade.blocks.FacadeBlock;
import mcjty.xnet.modules.facade.blocks.FacadeTileEntity;
import mcjty.xnet.modules.facade.blocks.ReplaceBlockItemUseContext;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class FacadeBlockItem
extends BlockItem
implements ITooltipSettings {
    private TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(stack -> !FacadeBlockItem.isMimicking(stack)), TooltipBuilder.parameter((String)"info", FacadeBlockItem::isMimicking, FacadeBlockItem::getMimickingString)});

    private static boolean isMimicking(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b("mimic");
    }

    private static String getMimickingString(ItemStack stack) {
        ItemStack s;
        CompoundNBT mimic;
        Block value;
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && (value = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((mimic = tag.func_74775_l("mimic")).func_74779_i("Name")))) != null && (s = new ItemStack((IItemProvider)value, 1)).func_77973_b() != null) {
            return s.func_200301_q().func_150254_d();
        }
        return "<unset>";
    }

    public FacadeBlockItem(FacadeBlock block) {
        super((Block)block, new Item.Properties().func_200916_a(XNet.setup.getTab()));
    }

    private static void userSetMimicBlock(@Nonnull ItemStack item, BlockState mimicBlock, ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        FacadeBlockItem.setMimicBlock(item, mimicBlock);
        if (world.field_72995_K) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Facade is now mimicking " + mimicBlock.func_177230_c().func_149739_a()), false);
        }
    }

    public static void setMimicBlock(@Nonnull ItemStack item, BlockState mimicBlock) {
        CompoundNBT tagCompound = new CompoundNBT();
        CompoundNBT nbt = NBTUtil.func_190009_a((BlockState)mimicBlock);
        tagCompound.func_218657_a("mimic", (INBT)nbt);
        item.func_77982_d(tagCompound);
    }

    public static BlockState getMimicBlock(@Nonnull ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("mimic")) {
            return Blocks.field_150347_e.func_176223_P();
        }
        return NBTUtil.func_190008_d((CompoundNBT)tagCompound.func_74775_l("mimic"));
    }

    protected boolean func_195944_a(BlockItemUseContext context, BlockState state) {
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack itemstack = context.func_195996_i();
        if (!itemstack.func_190926_b()) {
            if (block == CableModule.NETCABLE.get()) {
                ReplaceBlockItemUseContext blockContext = new ReplaceBlockItemUseContext(context);
                FacadeBlock facadeBlock = (FacadeBlock)this.func_179223_d();
                BlockState placementState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)facadeBlock.func_196258_a(blockContext).func_206870_a(GenericCableBlock.COLOR, state.func_177229_b(GenericCableBlock.COLOR))).func_206870_a(GenericCableBlock.NORTH, state.func_177229_b(GenericCableBlock.NORTH))).func_206870_a(GenericCableBlock.SOUTH, state.func_177229_b(GenericCableBlock.SOUTH))).func_206870_a(GenericCableBlock.WEST, state.func_177229_b(GenericCableBlock.WEST))).func_206870_a(GenericCableBlock.EAST, state.func_177229_b(GenericCableBlock.EAST))).func_206870_a(GenericCableBlock.UP, state.func_177229_b(GenericCableBlock.UP))).func_206870_a(GenericCableBlock.DOWN, state.func_177229_b(GenericCableBlock.DOWN));
                if (this.func_195941_b(blockContext, placementState)) {
                    SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), (IWorldReader)world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof FacadeTileEntity) {
                        ((FacadeTileEntity)te).setMimicBlock(FacadeBlockItem.getMimicBlock(itemstack));
                    }
                    int amount = -1;
                    itemstack.func_190917_f(amount);
                }
            } else if (block == CableModule.CONNECTOR.get() || block == CableModule.ADVANCED_CONNECTOR.get()) {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof ConnectorTileEntity) {
                    ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)te;
                    if (connectorTileEntity.getMimicBlock() == null) {
                        connectorTileEntity.setMimicBlock(FacadeBlockItem.getMimicBlock(itemstack));
                        SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), (IWorldReader)world, pos, (Entity)player);
                        world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                        int amount = -1;
                        itemstack.func_190917_f(amount);
                    } else {
                        FacadeBlockItem.userSetMimicBlock(itemstack, connectorTileEntity.getMimicBlock(), context);
                    }
                }
            } else if (block == FacadeModule.FACADE.get()) {
                TileEntity te = world.func_175625_s(pos);
                if (!(te instanceof IFacadeSupport)) {
                    return ActionResultType.FAIL;
                }
                IFacadeSupport facade = (IFacadeSupport)te;
                if (facade.getMimicBlock() == null) {
                    return ActionResultType.FAIL;
                }
                FacadeBlockItem.userSetMimicBlock(itemstack, facade.getMimicBlock(), context);
            } else {
                FacadeBlockItem.userSetMimicBlock(itemstack, state, context);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, worldIn, tooltip, flag);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), stack, tooltip, flag);
    }
}

