/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.controller.ControllerModule;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.multiblock.BlobId;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.IntPos;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class ChunkBlob {
    private final ChunkPos chunkPos;
    private final long chunkNum;
    private int lastBlobId = 0;
    private final Map<BlobId, Set<NetworkId>> networkMappings = new HashMap<BlobId, Set<NetworkId>>();
    private final Map<IntPos, BlobId> blobAllocations = new HashMap<IntPos, BlobId>();
    private final Map<IntPos, NetworkId> networkProviders = new HashMap<IntPos, NetworkId>();
    private final Map<IntPos, ConsumerId> networkConsumers = new HashMap<IntPos, ConsumerId>();
    private final Map<ConsumerId, IntPos> consumerPositions = new HashMap<ConsumerId, IntPos>();
    private final Map<BlobId, ColorId> blobColors = new HashMap<BlobId, ColorId>();
    private final Set<IntPos> cachedBorderPositions = new HashSet<IntPos>();
    private Map<NetworkId, Set<IntPos>> cachedConsumers = null;
    private Set<NetworkId> cachedNetworks = null;
    private Map<NetworkId, IntPos> cachedProviders = null;

    public ChunkBlob(ChunkPos chunkPos) {
        this.chunkPos = chunkPos;
        this.chunkNum = ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b);
    }

    public long getChunkNum() {
        return this.chunkNum;
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public BlockPos getPosition(IntPos pos) {
        return pos.toBlockPos(this.chunkPos);
    }

    @Nullable
    public IntPos getProviderPosition(@Nonnull NetworkId networkId) {
        if (this.cachedProviders == null) {
            this.cachedProviders = new HashMap<NetworkId, IntPos>();
            for (Map.Entry<IntPos, NetworkId> entry : this.networkProviders.entrySet()) {
                this.cachedProviders.put(entry.getValue(), entry.getKey());
            }
        }
        return this.cachedProviders.get(networkId);
    }

    @Nonnull
    public Set<NetworkId> getNetworksForPosition(IntPos pos) {
        BlobId blobId = this.blobAllocations.get(pos);
        if (this.networkMappings.containsKey(blobId)) {
            return this.networkMappings.get(blobId);
        }
        return Collections.emptySet();
    }

    @Nonnull
    public Set<NetworkId> getOrCreateNetworksForPosition(IntPos pos) {
        return this.getMappings(this.blobAllocations.get(pos));
    }

    @Nonnull
    public Set<IntPos> getBorderPositions() {
        return this.cachedBorderPositions;
    }

    @Nullable
    public BlobId getBlobIdForPosition(@Nonnull IntPos pos) {
        return this.blobAllocations.get(pos);
    }

    @Nullable
    public ColorId getColorIdForPosition(@Nonnull IntPos pos) {
        BlobId blob = this.getBlobIdForPosition(pos);
        if (blob == null) {
            return null;
        }
        return this.blobColors.get(blob);
    }

    @Nonnull
    public Set<NetworkId> getNetworks() {
        if (this.cachedNetworks == null) {
            this.cachedNetworks = new HashSet<NetworkId>();
            for (Set<NetworkId> networkIds : this.networkMappings.values()) {
                this.cachedNetworks.addAll(networkIds);
            }
        }
        return this.cachedNetworks;
    }

    @Nonnull
    private Set<NetworkId> getMappings(BlobId blobId) {
        if (!this.networkMappings.containsKey(blobId)) {
            this.networkMappings.put(blobId, new HashSet());
        }
        return this.networkMappings.get(blobId);
    }

    @Nonnull
    public Set<IntPos> getConsumersForNetwork(NetworkId network) {
        if (this.cachedConsumers == null) {
            this.cachedConsumers = new HashMap<NetworkId, Set<IntPos>>();
            for (Map.Entry<IntPos, ConsumerId> entry : this.networkConsumers.entrySet()) {
                IntPos pos = entry.getKey();
                BlobId blobId = this.blobAllocations.get(pos);
                Set<NetworkId> networkIds = this.networkMappings.get(blobId);
                if (networkIds == null) continue;
                for (NetworkId net : networkIds) {
                    if (!this.cachedConsumers.containsKey(net)) {
                        this.cachedConsumers.put(net, new HashSet());
                    }
                    this.cachedConsumers.get(net).add(pos);
                }
            }
        }
        if (this.cachedConsumers.containsKey(network)) {
            return this.cachedConsumers.get(network);
        }
        return Collections.emptySet();
    }

    public void check(World world) {
        System.out.println("Checking chunk: " + this.chunkPos);
        for (int cx = 0; cx < 16; ++cx) {
            for (int cz = 0; cz < 16; ++cz) {
                for (int cy = 0; cy < 256; ++cy) {
                    boolean hasid;
                    BlockPos pos = this.chunkPos.func_180331_a(cx, cy, cz);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    boolean bl = hasid = block == CableModule.CONNECTOR.get() || block == CableModule.ADVANCED_CONNECTOR.get() || block == CableModule.NETCABLE.get() || block == ControllerModule.CONTROLLER.get() || block == FacadeModule.FACADE.get();
                    if (hasid == this.blobAllocations.containsKey(new IntPos(pos))) continue;
                    if (hasid) {
                        System.out.println("Allocation at " + BlockPosTools.toString((BlockPos)pos) + " but no cable there!");
                        continue;
                    }
                    System.out.println("Missing allocation at " + BlockPosTools.toString((BlockPos)pos) + "!");
                }
            }
        }
    }

    public void fixNetworkAllocations() {
        this.cachedConsumers = null;
        this.cachedNetworks = null;
        this.networkMappings.clear();
        for (Map.Entry<IntPos, NetworkId> entry : this.networkProviders.entrySet()) {
            BlobId blobId = this.blobAllocations.get(entry.getKey());
            this.getMappings(blobId).add(entry.getValue());
        }
    }

    public void clearNetworkCache() {
        this.cachedNetworks = null;
    }

    public Map<IntPos, NetworkId> getNetworkProviders() {
        return this.networkProviders;
    }

    public void createNetworkProvider(BlockPos pos, ColorId color, NetworkId networkId) {
        IntPos posId = new IntPos(pos);
        this.networkProviders.put(posId, networkId);
        this.cachedProviders = null;
        this.createCableSegment(pos, color);
        this.getMappings(this.blobAllocations.get(posId)).add(networkId);
    }

    public Map<IntPos, ConsumerId> getNetworkConsumers() {
        return this.networkConsumers;
    }

    public IntPos getConsumerPosition(ConsumerId consumerId) {
        return this.consumerPositions.get(consumerId);
    }

    public void createNetworkConsumer(BlockPos pos, ColorId color, ConsumerId consumer) {
        IntPos posId = new IntPos(pos);
        this.networkConsumers.put(posId, consumer);
        this.consumerPositions.put(consumer, posId);
        this.createCableSegment(pos, color);
    }

    public void createCableSegment(BlockPos pos, ColorId color) {
        BlobId id;
        IntPos posId = new IntPos(pos);
        if (this.blobAllocations.containsKey(posId)) {
            return;
        }
        HashSet<BlobId> ids = new HashSet<BlobId>();
        for (int p : posId.getSidePositions()) {
            IntPos ip;
            BlobId blobId;
            if (p == -1 || (blobId = this.blobAllocations.get(ip = new IntPos(p))) == null || !this.blobColors.get(blobId).equals(color)) continue;
            ids.add(blobId);
        }
        if (posId.isBorder()) {
            this.cachedBorderPositions.add(posId);
        }
        if (ids.isEmpty()) {
            ++this.lastBlobId;
            BlobId blobId = new BlobId(this.lastBlobId);
            this.blobAllocations.put(posId, blobId);
            this.blobColors.put(blobId, color);
        } else if (ids.size() == 1) {
            id = (BlobId)ids.iterator().next();
            this.blobAllocations.put(posId, id);
        } else {
            id = (BlobId)ids.iterator().next();
            this.blobAllocations.put(posId, id);
            for (Map.Entry<IntPos, BlobId> entry : this.blobAllocations.entrySet()) {
                if (!ids.contains(entry.getValue())) continue;
                IntPos p = entry.getKey();
                this.blobAllocations.put(p, id);
            }
            HashSet networkIds = new HashSet();
            for (Map.Entry<BlobId, Set<NetworkId>> entry : this.networkMappings.entrySet()) {
                if (!ids.contains(entry.getKey())) continue;
                networkIds.addAll(entry.getValue());
            }
            this.networkMappings.put(id, networkIds);
            this.cachedConsumers = null;
            this.cachedNetworks = null;
        }
    }

    public boolean removeCableSegment(BlockPos pos) {
        IntPos posId = new IntPos(pos);
        if (!this.blobAllocations.containsKey(posId)) {
            return this.getBorderPositions().contains(posId);
        }
        if (this.networkConsumers.containsKey(posId)) {
            this.consumerPositions.remove(this.networkConsumers.get(posId));
            this.networkConsumers.remove(posId);
        }
        this.cachedConsumers = null;
        this.networkProviders.remove(posId);
        this.cachedProviders = null;
        ColorId oldColor = this.blobColors.get(this.blobAllocations.get(posId));
        int cnt = 0;
        for (int p : posId.getSidePositions()) {
            BlobId blobId;
            if (p == -1 || (blobId = this.blobAllocations.get(new IntPos(p))) == null || !this.blobColors.get(blobId).equals(oldColor)) continue;
            ++cnt;
        }
        boolean changed = false;
        this.blobAllocations.remove(posId);
        if (posId.isBorder()) {
            this.cachedBorderPositions.remove(posId);
            changed = true;
        }
        if (cnt > 1) {
            for (int p : posId.getSidePositions()) {
                IntPos ip;
                BlobId oldId;
                if (p == -1 || (oldId = this.blobAllocations.get(ip = new IntPos(p))) == null || !this.blobColors.get(oldId).equals(oldColor)) continue;
                this.networkMappings.remove(oldId);
                this.cachedNetworks = null;
                this.cachedConsumers = null;
                ++this.lastBlobId;
                BlobId newId = new BlobId(this.lastBlobId);
                this.blobColors.put(newId, oldColor);
                changed = this.propagateId(ip, oldColor, oldId, newId, changed);
            }
        }
        return changed;
    }

    private boolean propagateId(IntPos pos, ColorId color, BlobId oldId, BlobId newId, boolean changed) {
        this.blobAllocations.put(pos, newId);
        if (pos.isBorder()) {
            changed = true;
        }
        for (int p : pos.getSidePositions()) {
            IntPos ip;
            BlobId blobId;
            if (p == -1 || !oldId.equals(blobId = this.blobAllocations.get(ip = new IntPos(p))) || !this.blobColors.get(blobId).equals(color)) continue;
            changed = this.propagateId(ip, color, oldId, newId, changed);
        }
        return changed;
    }

    private String toString(IntPos pos) {
        BlockPos p = this.getPosition(pos);
        return pos.getX() + "," + pos.getY() + "," + pos.getZ() + " (real:" + p.func_177958_n() + "," + p.func_177956_o() + "," + p.func_177952_p() + ")";
    }

    public void dump() {
        System.out.println("################# Chunk (" + this.chunkPos.field_77276_a + "," + this.chunkPos.field_77275_b + ") #################");
        System.out.println("Network providers:");
        for (Map.Entry<IntPos, NetworkId> entry : this.networkProviders.entrySet()) {
            System.out.println("    " + this.toString(entry.getKey()) + ", network = " + entry.getValue().getId());
        }
        System.out.println("Network consumers:");
        for (Map.Entry<IntPos, NetworkId> entry : this.networkConsumers.entrySet()) {
            System.out.println("    " + this.toString(entry.getKey()) + ", consumer = " + ((ConsumerId)entry.getValue()).getId());
        }
        System.out.println("Network mappings:");
        for (Map.Entry<Object, Object> entry : this.networkMappings.entrySet()) {
            String s = "";
            for (NetworkId networkId : (Set)entry.getValue()) {
                s = s + networkId.getId() + " ";
            }
            System.out.println("    Blob(" + ((BlobId)entry.getKey()).getId() + "): networks = " + s);
        }
        System.out.println("Blob colors:");
        for (Map.Entry<Object, Object> entry : this.blobColors.entrySet()) {
            System.out.println("    Blob(" + ((BlobId)entry.getKey()).getId() + "): color = " + ((ColorId)entry.getValue()).getId());
        }
        System.out.println("Allocations:");
        for (Map.Entry<Object, Object> entry : this.blobAllocations.entrySet()) {
            System.out.println("    " + this.toString((IntPos)entry.getKey()) + ", Blob(" + ((BlobId)entry.getValue()).getId() + ")");
        }
    }

    public void readFromNBT(CompoundNBT compound) {
        BlobId blob;
        int idx;
        this.networkMappings.clear();
        this.blobAllocations.clear();
        this.networkProviders.clear();
        this.blobColors.clear();
        this.cachedBorderPositions.clear();
        this.cachedNetworks = null;
        this.cachedConsumers = null;
        this.cachedProviders = null;
        this.lastBlobId = compound.func_74762_e("lastBlob");
        HashSet<BlobId> foundBlobs = new HashSet<BlobId>();
        if (compound.func_74764_b("allocations")) {
            int[] allocations = compound.func_74759_k("allocations");
            for (idx = 0; idx < allocations.length - 1; idx += 2) {
                IntPos pos = new IntPos(allocations[idx]);
                blob = new BlobId(allocations[idx + 1]);
                this.blobAllocations.put(pos, blob);
                foundBlobs.add(blob);
                if (!pos.isBorder()) continue;
                this.cachedBorderPositions.add(pos);
            }
        }
        if (compound.func_74764_b("mappings")) {
            int[] mappings = compound.func_74759_k("mappings");
            for (idx = 0; idx < mappings.length - 1; ++idx) {
                int key = mappings[idx];
                blob = new BlobId(key);
                HashSet<NetworkId> ids = new HashSet<NetworkId>();
                ++idx;
                while (idx < mappings.length && mappings[idx] != -1) {
                    ids.add(new NetworkId(mappings[idx]));
                    ++idx;
                }
                if (!foundBlobs.contains(blob)) continue;
                this.networkMappings.put(blob, ids);
            }
        }
        if (compound.func_74764_b("providers")) {
            int[] providers = compound.func_74759_k("providers");
            for (idx = 0; idx < providers.length - 1; idx += 2) {
                this.networkProviders.put(new IntPos(providers[idx]), new NetworkId(providers[idx + 1]));
            }
        }
        if (compound.func_74764_b("consumers")) {
            int[] consumers = compound.func_74759_k("consumers");
            for (idx = 0; idx < consumers.length - 1; idx += 2) {
                IntPos intPos = new IntPos(consumers[idx]);
                ConsumerId consumerId = new ConsumerId(consumers[idx + 1]);
                this.networkConsumers.put(intPos, consumerId);
                this.consumerPositions.put(consumerId, intPos);
            }
        }
        if (compound.func_74764_b("colors")) {
            int[] colors = compound.func_74759_k("colors");
            for (idx = 0; idx < colors.length - 1; idx += 2) {
                BlobId blob2 = new BlobId(colors[idx]);
                ColorId color = new ColorId(colors[idx + 1]);
                if (!foundBlobs.contains(blob2)) continue;
                this.blobColors.put(blob2, color);
            }
        }
    }

    public CompoundNBT writeToNBT(CompoundNBT compound) {
        compound.func_74768_a("lastBlob", this.lastBlobId);
        ArrayList<Integer> m = new ArrayList<Integer>();
        for (Map.Entry<BlobId, Set<NetworkId>> entry : this.networkMappings.entrySet()) {
            m.add(entry.getKey().getId());
            for (NetworkId networkId : entry.getValue()) {
                m.add(networkId.getId());
            }
            m.add(-1);
        }
        IntArrayNBT mappings = new IntArrayNBT(m.stream().mapToInt(i -> i).toArray());
        compound.func_218657_a("mappings", (INBT)mappings);
        m.clear();
        for (Map.Entry<IntPos, BlobId> entry : this.blobAllocations.entrySet()) {
            m.add(entry.getKey().getPos());
            m.add(entry.getValue().getId());
        }
        IntArrayNBT intArrayNBT = new IntArrayNBT(m.stream().mapToInt(i -> i).toArray());
        compound.func_218657_a("allocations", (INBT)intArrayNBT);
        m.clear();
        for (Map.Entry<IntPos, NetworkId> entry : this.networkProviders.entrySet()) {
            m.add(entry.getKey().getPos());
            m.add(entry.getValue().getId());
        }
        IntArrayNBT intArrayNBT2 = new IntArrayNBT(m.stream().mapToInt(i -> i).toArray());
        compound.func_218657_a("providers", (INBT)intArrayNBT2);
        m.clear();
        for (Map.Entry<IntPos, ConsumerId> entry : this.networkConsumers.entrySet()) {
            m.add(entry.getKey().getPos());
            m.add(entry.getValue().getId());
        }
        IntArrayNBT intArrayNBT3 = new IntArrayNBT(m.stream().mapToInt(i -> i).toArray());
        compound.func_218657_a("consumers", (INBT)intArrayNBT3);
        m.clear();
        for (Map.Entry<BlobId, ColorId> entry : this.blobColors.entrySet()) {
            m.add(entry.getKey().getId());
            m.add(entry.getValue().getId());
        }
        IntArrayNBT intArrayNBT4 = new IntArrayNBT(m.stream().mapToInt(i -> i).toArray());
        compound.func_218657_a("colors", (INBT)intArrayNBT4);
        return compound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkBlob chunkBlob = (ChunkBlob)o;
        return this.chunkNum == chunkBlob.chunkNum;
    }

    public int hashCode() {
        return (int)(this.chunkNum ^ this.chunkNum >>> 32);
    }
}

