/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout;

import com.ldtteam.blockout.Alignment;
import com.ldtteam.blockout.BOScreen;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Render;
import com.ldtteam.blockout.ToolTipRendering;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Pane
extends AbstractGui {
    @NotNull
    private static final Deque<ScissorsInfo> scissorsInfoStack = new ConcurrentLinkedDeque<ScissorsInfo>();
    private static final int SCISSOR_X_INDEX = 12;
    private static final int SCISSOR_Y_INDEX = 13;
    protected static Pane lastClickedPane;
    protected static Pane focus;
    protected Pane onHover;
    protected static boolean debugging;
    protected Minecraft mc = Minecraft.func_71410_x();
    protected String id = "";
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected Alignment alignment = Alignment.TOP_LEFT;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected String onHoverId = "";
    protected Window window;
    protected View parent;
    protected boolean isHovered = false;
    private List<String> toolTipLines = new ArrayList<String>();

    public Pane() {
    }

    public Pane(@NotNull PaneParams params) {
        this.id = params.getStringAttribute("id", this.id);
        PaneParams.SizePair parentSizePair = new PaneParams.SizePair(params.getParentWidth(), params.getParentHeight());
        PaneParams.SizePair sizePair = params.getSizePairAttribute("size", null, parentSizePair);
        if (sizePair != null) {
            this.width = sizePair.getX();
            this.height = sizePair.getY();
        } else {
            this.width = params.getScalableIntegerAttribute("width", this.width, parentSizePair.getX());
            this.height = params.getScalableIntegerAttribute("height", this.height, parentSizePair.getY());
        }
        sizePair = params.getSizePairAttribute("pos", null, parentSizePair);
        if (sizePair != null) {
            this.x = sizePair.getX();
            this.y = sizePair.getY();
        } else {
            this.x = params.getScalableIntegerAttribute("x", this.x, parentSizePair.getX());
            this.y = params.getScalableIntegerAttribute("y", this.y, parentSizePair.getY());
        }
        this.alignment = params.getEnumAttribute("align", Alignment.class, this.alignment);
        this.visible = params.getBooleanAttribute("visible", this.visible);
        this.enabled = params.getBooleanAttribute("enabled", this.enabled);
        this.onHoverId = params.getStringAttribute("onHoverId");
        this.toolTipLines = params.getToolTipAttribute("tooltip");
    }

    public static synchronized Pane getFocus() {
        return focus;
    }

    public static void clearFocus() {
        Pane.setFocus(null);
    }

    public void onFocusLost() {
    }

    public void onFocus() {
    }

    public void parseChildren(PaneParams params) {
    }

    public final String getID() {
        return this.id;
    }

    public final void setID(String id) {
        this.id = id;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setPosition(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    public void moveBy(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void on() {
        this.setEnabled(true);
        this.setVisible(true);
    }

    public void off() {
        this.setEnabled(false);
        this.setVisible(false);
    }

    public final void setFocus() {
        Pane.setFocus(this);
    }

    public final synchronized boolean isFocus() {
        return focus == this;
    }

    public static synchronized void setFocus(Pane f) {
        if (focus != null) {
            focus.onFocusLost();
        }
        if ((focus = f) != null) {
            focus.onFocus();
        }
    }

    public final void draw(int mx, int my) {
        if (this.visible) {
            this.drawSelf(mx, my);
            if (debugging) {
                boolean isMouseOver = this.isPointInPane(mx, my);
                int color = isMouseOver ? -16711936 : -16776961;
                Render.drawOutlineRect(this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), color);
                if (isMouseOver && !this.id.isEmpty()) {
                    int stringWidth = this.mc.field_71466_p.func_78256_a(this.id);
                    FontRenderer fontRenderer = this.mc.field_71466_p;
                    float f = this.x + this.getWidth() - stringWidth;
                    int n = this.y + this.getHeight();
                    this.mc.field_71466_p.getClass();
                    fontRenderer.func_211126_b(this.id, f, (float)(n - 9), color);
                }
            }
        }
    }

    public final void drawLast(int mx, int my) {
        if (this.visible) {
            this.drawSelfLast(mx, my);
            if (this.isHovered && !this.toolTipLines.isEmpty()) {
                RenderSystem.pushMatrix();
                RenderHelper.func_74518_a();
                RenderSystem.translatef((float)mx, (float)my, (float)32.0f);
                RenderSystem.scalef((float)((float)this.getWidth() / 16.0f), (float)((float)this.getHeight() / 16.0f), (float)1.0f);
                ToolTipRendering.drawHoveringText(this.toolTipLines, 0, 0, this.getWindow().getScreen().width, this.getWindow().getScreen().height, -1, -267386864, 0x505000FF, 1344798847, this.mc.field_71466_p);
                RenderSystem.popMatrix();
            }
        }
    }

    public void drawSelf(int mx, int my) {
    }

    public void drawSelfLast(int mx, int my) {
    }

    public boolean isPointInPane(double mx, double my) {
        return this.isVisible() && mx >= (double)this.x && mx < (double)(this.x + this.width) && my >= (double)this.y && my < (double)(this.y + this.height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final <T extends Pane> T findPaneOfTypeByID(String idIn, @NotNull Class<T> type) {
        Pane p = this.findPaneByID(idIn);
        try {
            return (T)((Object)((Pane)((Object)type.cast((Object)p))));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("No pane with id %s and type %s was found.", idIn, type), e);
        }
    }

    @Nullable
    public Pane findPaneByID(String idIn) {
        return this.id.equals(idIn) ? this : null;
    }

    public final View getParent() {
        return this.parent;
    }

    public final Window getWindow() {
        return this.window;
    }

    public void setWindow(Window w) {
        this.window = w;
    }

    public void putInside(View newParent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public boolean isClickable() {
        return this.visible && this.enabled;
    }

    public boolean click(double mx, double my) {
        Pane.setLastClickedPane(this);
        return this.handleClick(mx - (double)this.x, my - (double)this.y);
    }

    public boolean rightClick(double mx, double my) {
        Pane.setLastClickedPane(this);
        return this.handleRightClick(mx - (double)this.x, my - (double)this.y);
    }

    private static synchronized void setLastClickedPane(Pane pane) {
        lastClickedPane = pane;
    }

    public boolean handleClick(double mx, double my) {
        return false;
    }

    public boolean handleRightClick(double mx, double my) {
        return false;
    }

    public boolean canHandleClick(double mx, double my) {
        return this.visible && this.enabled && this.isPointInPane(mx, my);
    }

    public boolean onKeyTyped(char ch, int key) {
        return false;
    }

    public void onUpdate() {
    }

    protected synchronized void scissorsStart() {
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)64);
        GL11.glGetFloatv((int)2982, (FloatBuffer)fb);
        int scissorsX = (int)fb.get(12) + this.getX();
        int scissorsY = (int)fb.get(13) + this.getY();
        int h = this.getHeight();
        int w = this.getWidth();
        if (!scissorsInfoStack.isEmpty()) {
            ScissorsInfo parentInfo = scissorsInfoStack.peek();
            int right = scissorsX + w;
            int bottom = scissorsY + h;
            int parentRight = parentInfo.x + parentInfo.width;
            int parentBottom = parentInfo.y + parentInfo.height;
            scissorsX = Math.max(scissorsX, parentInfo.x);
            scissorsY = Math.max(scissorsY, parentInfo.y);
            w = Math.max(0, Math.min(right, parentRight) - scissorsX);
            h = Math.max(0, Math.min(bottom, parentBottom) - scissorsY);
        }
        GL11.glEnable((int)3089);
        ScissorsInfo info = new ScissorsInfo(scissorsX, scissorsY, w, h);
        scissorsInfoStack.push(info);
        double scale = BOScreen.getScale();
        GL11.glPushAttrib((int)524288);
        GL11.glScissor((int)((int)((double)info.x * scale)), (int)((int)((double)(this.mc.field_195558_d.func_198087_p() - info.y - info.height) * scale)), (int)((int)((double)info.width * scale)), (int)((int)((double)info.height * scale)));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    protected synchronized void scissorsEnd() {
        scissorsInfoStack.pop();
        GL11.glPopAttrib();
        GL11.glDisable((int)3089);
        if (!scissorsInfoStack.isEmpty()) {
            GL11.glEnable((int)3089);
            ScissorsInfo info = scissorsInfoStack.peek();
            double scale = BOScreen.getScale();
            GL11.glPushAttrib((int)524288);
            GL11.glScissor((int)((int)((double)info.x * scale)), (int)((int)((double)(this.mc.field_195558_d.func_198087_p() - info.y - info.height) * scale)), (int)((int)((double)info.width * scale)), (int)((int)((double)info.height * scale)));
        }
    }

    public boolean scrollInput(double wheel, double mx, double my) {
        return false;
    }

    public void setParentView(View view) {
        this.parent = view;
    }

    public boolean handleUnhover(double mx, double mz) {
        this.handleUnhover();
        return true;
    }

    public void handleUnhover() {
        this.isHovered = false;
        if (this.onHover != null) {
            this.onHover.hide();
        }
    }

    public boolean handleHover(double mx, double my) {
        if (this.isPointInPane(mx, my)) {
            this.isHovered = true;
        }
        if (this.onHover == null) {
            if (!this.onHoverId.isEmpty()) {
                this.onHover = this.window.findPaneByID(this.onHoverId);
            } else {
                return false;
            }
        }
        if (!this.isVisible()) {
            if (this.onHover.isVisible()) {
                this.onHover.hide();
            }
            return false;
        }
        if (this.isPointInPane(mx, my) && !this.onHover.isVisible()) {
            this.onHover.show();
        }
        return true;
    }

    protected int drawString(String text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            return this.mc.field_71466_p.func_175063_a(text, x, y, color);
        }
        return this.mc.field_71466_p.func_211126_b(text, x, y, color);
    }

    public boolean onMouseDrag(double mx, double my, int speed, double deltaX, double deltaY) {
        return false;
    }

    public void setHoverToolTip(List<String> lines) {
        this.toolTipLines = lines;
    }

    static {
        debugging = false;
    }

    private static class ScissorsInfo {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        ScissorsInfo(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }
    }
}

