/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.controls.AbstractTextElement;
import com.mojang.blaze3d.systems.RenderSystem;

public class Label
extends AbstractTextElement {
    protected String labelText;
    protected int hoverColor = 0xFFFFFF;
    protected boolean wrap = false;

    public Label() {
    }

    public Label(PaneParams params) {
        super(params);
        this.labelText = params.getLocalizedStringAttribute("label", this.labelText);
        this.hoverColor = params.getColorAttribute("hovercolor", this.textColor);
        this.wrap = params.getBooleanAttribute("wrap", this.wrap);
        if (this.width == 0) {
            this.width = Math.min(this.mc.field_71466_p.func_78256_a(this.labelText), params.getParentWidth());
        }
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String s) {
        this.labelText = s;
    }

    public int getHoverColor() {
        return this.hoverColor;
    }

    public void setColor(int c, int h) {
        this.setColor(c);
        this.hoverColor = h;
    }

    @Override
    public void drawSelf(int mx, int my) {
        int color = this.isPointInPane(mx, my) ? this.hoverColor : this.textColor;
        int offsetX = 0;
        int offsetY = 0;
        if (this.textAlignment.isRightAligned()) {
            offsetX = this.getWidth() - this.getStringWidth();
        } else if (this.textAlignment.isHorizontalCentered()) {
            offsetX = (this.getWidth() - this.getStringWidth()) / 2;
        }
        if (this.textAlignment.isBottomAligned()) {
            offsetY = this.getHeight() - this.getTextHeight();
        } else if (this.textAlignment.isVerticalCentered()) {
            offsetY = (this.getHeight() - this.getTextHeight()) / 2;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(this.getX() + offsetX), (double)(this.getY() + offsetY), (double)0.0);
        RenderSystem.scalef((float)((float)this.scale), (float)((float)this.scale), (float)((float)this.scale));
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        if (this.labelText != null && this.wrap) {
            this.mc.field_71466_p.func_78279_b(this.labelText, 0, 0, this.width, color);
        } else {
            this.drawString(this.labelText, 0.0f, 0.0f, color, this.shadow);
        }
        RenderSystem.popMatrix();
    }

    @Override
    public void drawSelfLast(int mx, int my) {
    }

    public int getStringWidth() {
        return (int)((double)this.mc.field_71466_p.func_78256_a(this.labelText) * this.scale);
    }

    public int getTextHeight() {
        this.mc.field_71466_p.getClass();
        return (int)(9.0 * this.scale);
    }
}

