/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.views.ScrollingView;
import com.ldtteam.blockout.views.View;
import com.mojang.blaze3d.systems.RenderSystem;
import org.jetbrains.annotations.NotNull;

public class ScrollingContainer
extends View {
    private static final int PERCENT_90 = 90;
    private static final int PERCENT_FULL = 100;
    protected ScrollingView owner;
    protected double scrollY = 0.0;
    protected int contentHeight = 0;

    ScrollingContainer(ScrollingView owner) {
        this.owner = owner;
    }

    @Override
    public void parseChildren(PaneParams params) {
        super.parseChildren(params);
        this.computeContentHeight();
    }

    public void computeContentHeight() {
        this.contentHeight = 0;
        for (Pane child : this.children) {
            if (child == null) continue;
            this.contentHeight = Math.max(this.contentHeight, child.getY() + child.getHeight());
        }
        this.setScrollY(this.scrollY);
    }

    public void setContentHeight(int size) {
        this.contentHeight = size;
        this.setScrollY(this.scrollY);
    }

    public int getMaxScrollY() {
        return Math.max(0, this.contentHeight - this.getHeight());
    }

    @Override
    public void drawSelf(int mx, int my) {
        this.scissorsStart();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)((float)(-this.scrollY)), (float)0.0f);
        super.drawSelf(mx, my + (int)this.scrollY);
        RenderSystem.popMatrix();
        this.scissorsEnd();
    }

    @Override
    public void drawSelfLast(int mx, int my) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)((float)(-this.scrollY)), (float)0.0f);
        super.drawSelfLast(mx, my + (int)this.scrollY);
        RenderSystem.popMatrix();
    }

    @Override
    public boolean handleHover(double mx, double my) {
        return super.handleHover(mx, my + (double)((int)this.scrollY));
    }

    @Override
    public boolean click(double mx, double my) {
        return super.click(mx, my + this.scrollY);
    }

    @Override
    protected boolean childIsVisible(@NotNull Pane child) {
        return child.getX() < this.getWidth() && (double)child.getY() < (double)this.getHeight() + this.scrollY && child.getX() + child.getWidth() >= 0 && (double)(child.getY() + child.getHeight()) >= this.scrollY;
    }

    public double getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(double offset) {
        this.scrollY = offset;
        double maxScrollY = this.getMaxScrollY();
        if (this.scrollY > maxScrollY) {
            this.scrollY = maxScrollY;
        }
        if (this.scrollY < 0.0) {
            this.scrollY = 0.0;
        }
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getScrollPageSize() {
        return this.getHeight() * 90 / 100;
    }

    public void scrollBy(double deltaY) {
        this.setScrollY(this.scrollY + deltaY);
    }
}

