/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.views.ZoomDragView;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;

public class TreeView
extends ZoomDragView {
    private List<TreeViewNode> treeRoots;
    private List<PaneParams> templates;
    private int nodeVerticalDistance = 10;
    private int nodeToLineDistance = 10;
    private int lineSize = 2;
    private final int[] color = new int[4];
    private final int nodeHorizontalDistance;
    private Pair<BufferBuilder.DrawState, ByteBuffer> lineBuffer;

    public TreeView() {
        this.nodeHorizontalDistance = 0;
    }

    public TreeView(PaneParams params) {
        super(params);
        this.nodeVerticalDistance = params.getIntAttribute("nodeVertDist", this.nodeVerticalDistance);
        this.nodeToLineDistance = params.getIntAttribute("nodeToLineHorizDist", this.nodeToLineDistance);
        this.lineSize = params.getIntAttribute("lineSize", this.lineSize);
        int linePackedColor = params.getIntAttribute("linePackedColor", -1);
        this.nodeHorizontalDistance = 2 * this.nodeToLineDistance + this.lineSize;
        this.color[0] = linePackedColor >> 24;
        this.color[1] = linePackedColor >> 16 & 0xFF;
        this.color[2] = linePackedColor >> 8 & 0xFF;
        this.color[3] = linePackedColor & 0xFF;
    }

    public void setRoots(List<TreeViewNode> treeRootsIn) {
        this.treeRoots = treeRootsIn;
        this.reconstruct();
    }

    public void reconstruct() {
        int i;
        Object pane;
        int i2;
        ArrayList<List<TreeViewNode>> layers = new ArrayList<List<TreeViewNode>>();
        for (TreeViewNode root : this.treeRoots) {
            this.construct(layers, 0, root);
        }
        int max = Integer.MIN_VALUE;
        int maxId = -1;
        int[] layerOffsets = new int[layers.size() + 1];
        for (i2 = 0; i2 < layers.size(); ++i2) {
            int height = 0;
            for (TreeViewNode node : (List)layers.get(i2)) {
                pane = node.pane;
                height += ((Pane)((Object)pane)).getHeight();
                height += this.nodeVerticalDistance;
                if (layerOffsets[i2 + 1] >= ((Pane)((Object)pane)).getWidth()) continue;
                layerOffsets[i2 + 1] = ((Pane)((Object)pane)).getWidth();
            }
            if ((height -= this.nodeVerticalDistance) < max) continue;
            max = height;
            maxId = i2;
        }
        for (i2 = 1; i2 < layerOffsets.length; ++i2) {
            int n = i2;
            layerOffsets[n] = layerOffsets[n] + this.nodeHorizontalDistance;
            if (i2 + 1 >= layerOffsets.length) continue;
            int n2 = i2 + 1;
            layerOffsets[n2] = layerOffsets[n2] + layerOffsets[i2];
        }
        BufferBuilder bufferBuilder = new BufferBuilder(512);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int curY = 0;
        for (TreeViewNode node : (List)layers.get(maxId)) {
            pane = node.pane;
            ((Pane)((Object)pane)).setPosition(layerOffsets[maxId], curY);
            curY += ((Pane)((Object)pane)).getHeight() + this.nodeVerticalDistance;
        }
        for (i = maxId - 1; i >= 0; --i) {
            curY = 0;
            Pane postponesPane = null;
            for (TreeViewNode node : (List)layers.get(i)) {
                Pane pane2 = node.pane;
                if (node.childs.isEmpty()) {
                    if (postponesPane != null) {
                        postponesPane.setPosition(layerOffsets[i], curY);
                        curY += postponesPane.getHeight() + this.nodeVerticalDistance;
                    }
                    postponesPane = pane2;
                    continue;
                }
                int childTop = ((TreeViewNode)node.childs.get(0)).pane.getY();
                Pane childBotNode = ((TreeViewNode)node.childs.get(node.childs.size() - 1)).pane;
                int childBot = childBotNode.getY() + childBotNode.getHeight();
                int newCurY = (childTop + childBot - pane2.getHeight()) / 2;
                newCurY = Math.max(curY, newCurY);
                if (postponesPane != null) {
                    int postY = (curY + newCurY - this.nodeVerticalDistance - postponesPane.getHeight()) / 2;
                    if (postY < curY) {
                        postY = curY;
                        newCurY = curY + postponesPane.getHeight() + this.nodeVerticalDistance;
                    }
                    postponesPane.setPosition(layerOffsets[i], postY);
                    postponesPane = null;
                }
                pane2.setPosition(layerOffsets[i], newCurY);
                int x = pane2.getX() + pane2.getWidth();
                this.hLine(bufferBuilder, x, x + this.nodeToLineDistance + this.lineSize / 2, newCurY + pane2.getHeight() / 2);
                x += this.nodeToLineDistance + this.lineSize / 2;
                int minY = Integer.MAX_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (TreeViewNode child : node.childs) {
                    Pane childPane = child.pane;
                    int y = childPane.getY() + childPane.getHeight() / 2;
                    this.hLine(bufferBuilder, x, childPane.getX(), y);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                }
                this.vLine(bufferBuilder, x, minY - this.lineSize / 2, maxY + this.lineSize / 2);
                curY = newCurY + pane2.getHeight() + this.nodeVerticalDistance;
            }
        }
        for (i = maxId; i < layers.size(); ++i) {
            curY = 0;
            for (TreeViewNode node : (List)layers.get(i)) {
                if (node.childs.isEmpty()) continue;
                Pane pane3 = node.pane;
                int childBranchHeight = 0;
                for (TreeViewNode child : node.childs) {
                    childBranchHeight += child.pane.getHeight() + this.nodeVerticalDistance;
                }
                curY = Math.max(curY, pane3.getY() + pane3.getHeight() / 2 - (childBranchHeight -= this.nodeVerticalDistance) / 2);
                int x = pane3.getX() + pane3.getWidth();
                this.hLine(bufferBuilder, x, x + this.nodeToLineDistance + this.lineSize / 2, pane3.getY() + pane3.getHeight() / 2);
                x += this.nodeToLineDistance + this.lineSize / 2;
                int minY = Integer.MAX_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (TreeViewNode child : node.childs) {
                    Pane childPane = child.pane;
                    childPane.setPosition(layerOffsets[i + 1], curY);
                    int y = curY + childPane.getHeight() / 2;
                    this.hLine(bufferBuilder, x, childPane.getX(), y);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    curY += childPane.getHeight() + this.nodeVerticalDistance;
                }
                this.vLine(bufferBuilder, x, minY - this.lineSize / 2, maxY + this.lineSize / 2);
            }
        }
        this.computeContentSize();
        bufferBuilder.func_178977_d();
        this.lineBuffer = bufferBuilder.func_227832_f_();
    }

    private void hLine(BufferBuilder bufferBuilder, int fromX, int toX, int y) {
        bufferBuilder.func_225582_a_((double)fromX, (double)(y - this.lineSize / 2), 0.0).func_225586_a_(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        bufferBuilder.func_225582_a_((double)fromX, (double)(y + this.lineSize / 2), 0.0).func_225586_a_(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        bufferBuilder.func_225582_a_((double)toX, (double)(y + this.lineSize / 2), 0.0).func_225586_a_(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        bufferBuilder.func_225582_a_((double)toX, (double)(y - this.lineSize / 2), 0.0).func_225586_a_(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
    }

    private void vLine(BufferBuilder bufferBuilder, int x, int fromY, int toY) {
        bufferBuilder.func_225582_a_((double)(x - this.lineSize / 2), (double)fromY, 0.0).func_225586_a_(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + this.lineSize / 2), (double)fromY, 0.0).func_225586_a_(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + this.lineSize / 2), (double)toY, 0.0).func_225586_a_(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x - this.lineSize / 2), (double)toY, 0.0).func_225586_a_(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
    }

    private void construct(List<List<TreeViewNode>> layers, int layer, TreeViewNode root) {
        List<TreeViewNode> paneLayer;
        if (root == null) {
            return;
        }
        List<TreeViewNode> list = paneLayer = layer < layers.size() ? layers.get(layer) : null;
        if (paneLayer == null) {
            paneLayer = new ArrayList<TreeViewNode>();
            layers.add(paneLayer);
        }
        if (this.templates.get(root.typeId) == null) {
            throw new RuntimeException("Invalid type id for node, type id: " + root.typeId);
        }
        if (root.pane == null) {
            Pane rootPane = Loader.createFromPaneParams(this.templates.get(root.typeId), this);
            super.treeViewHelperAddChild(rootPane);
            root.pane = rootPane;
            root.paneUpdater.accept(rootPane);
        }
        paneLayer.add(root);
        for (TreeViewNode child : root.childs) {
            this.construct(layers, layer + 1, child);
        }
    }

    @Override
    public void parseChildren(@NotNull PaneParams params) {
        List<PaneParams> childNodes = params.getChildren();
        if (childNodes == null) {
            return;
        }
        this.templates = new ArrayList<PaneParams>();
        for (PaneParams paneParams : childNodes) {
            this.templates.add(paneParams);
        }
    }

    private void onUpdate(TreeViewNode root) {
        if (root == null) {
            return;
        }
        if (root.updatable) {
            root.paneUpdater.accept(root.pane);
        }
        for (TreeViewNode child : root.childs) {
            this.onUpdate(child);
        }
    }

    @Override
    public void onUpdate() {
        for (TreeViewNode root : this.treeRoots) {
            this.onUpdate(root);
        }
        super.onUpdate();
    }

    @Override
    protected void abstractDrawSelfPost(int mx, int my) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.x, (float)this.y, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        ((ByteBuffer)this.lineBuffer.getSecond()).clear();
        if (((BufferBuilder.DrawState)this.lineBuffer.getFirst()).func_227839_b_() > 0) {
            ((BufferBuilder.DrawState)this.lineBuffer.getFirst()).func_227838_a_().func_227892_a_(MemoryUtil.memAddress((ByteBuffer)((ByteBuffer)this.lineBuffer.getSecond())));
            GlStateManager.func_227719_f_((int)((BufferBuilder.DrawState)this.lineBuffer.getFirst()).func_227840_c_(), (int)0, (int)((BufferBuilder.DrawState)this.lineBuffer.getFirst()).func_227839_b_());
            ((BufferBuilder.DrawState)this.lineBuffer.getFirst()).func_227838_a_().func_227895_d_();
        }
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    public static class TreeViewNode {
        public static final Consumer<Pane> NOOP_PANE_UPDATER = pane -> {};
        private final List<TreeViewNode> childs;
        private final Consumer<Pane> paneUpdater;
        private final boolean updatable;
        private final int typeId;
        private Pane pane;

        public TreeViewNode(Consumer<Pane> paneUpdater, boolean updatable, int typeId) {
            this(paneUpdater, updatable, typeId, new ArrayList<TreeViewNode>());
        }

        public TreeViewNode(Consumer<Pane> paneUpdater, boolean updatable, int typeId, List<TreeViewNode> childs) {
            this.paneUpdater = paneUpdater;
            this.updatable = updatable;
            this.typeId = typeId;
            this.childs = childs;
        }

        public Pane getPane() {
            return this.pane;
        }

        public List<TreeViewNode> getChilds() {
            return this.childs;
        }
    }
}

