/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.BOScreen;
import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.views.View;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class Window
extends View {
    private static final int DEFAULT_WIDTH = 420;
    private static final int DEFAULT_HEIGHT = 240;
    protected BOScreen screen;
    protected boolean windowPausesGame = true;
    protected boolean lightbox = true;

    public Window(ResourceLocation resource) {
        this();
        Loader.createFromXMLFile(resource, (View)this);
    }

    public Window() {
        this(420, 240);
    }

    public Window(int w, int h) {
        this.width = w;
        this.height = h;
        this.screen = new BOScreen(this);
        this.window = this;
    }

    public Window(String resource) {
        this();
        Loader.createFromXMLFile(resource, (View)this);
    }

    public void loadParams(@NotNull PaneParams params) {
        PaneParams.SizePair size;
        String inherit = params.getStringAttribute("inherit", null);
        if (inherit != null) {
            Loader.createFromXMLFile(new ResourceLocation(inherit), (View)this);
        }
        if ((size = params.getSizePairAttribute("size", null, null)) == null) {
            int w = params.getIntAttribute("width", this.width);
            int h = params.getIntAttribute("height", this.height);
            this.setSize(w, h);
        } else {
            this.setSize(size.getX(), size.getY());
        }
        this.lightbox = params.getBooleanAttribute("lightbox", this.lightbox);
        this.windowPausesGame = params.getBooleanAttribute("pause", this.windowPausesGame);
    }

    @Override
    public void parseChildren(PaneParams params) {
    }

    @Override
    public void drawSelf(int mx, int my) {
        this.updateDebugging();
        super.drawSelf(mx, my);
    }

    @Override
    public void drawSelfLast(int mx, int my) {
        super.drawSelfLast(mx, my);
    }

    private boolean isKeyDown(int keyCode) {
        return InputMappings.func_216506_a((long)this.mc.field_195558_d.func_198092_i(), (int)keyCode);
    }

    private void updateDebugging() {
        debugging = this.isKeyDown(340) && this.isKeyDown(342) && (this.isKeyDown(341) || this.isKeyDown(343));
    }

    public boolean hasLightbox() {
        return this.lightbox;
    }

    public boolean doesWindowPauseGame() {
        return this.windowPausesGame;
    }

    public void open() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.mc.func_213167_f(() -> this.mc.func_147108_a((Screen)this.screen)));
    }

    public BOScreen getScreen() {
        return this.screen;
    }

    public boolean onMouseReleased(double mx, double my) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        if (Window.getFocus() != null && Window.getFocus().onKeyTyped(ch, key)) {
            return true;
        }
        return this.onUnhandledKeyTyped(ch, key);
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (key == 256) {
            this.close();
            return true;
        }
        return false;
    }

    public void close() {
        this.screen.onClose();
        this.mc.field_71439_g.func_71053_j();
    }

    public void onOpened() {
    }

    public void onClosed() {
    }
}

