/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection;

public class PrimesCache {
    public static final int DEFAULT_MAX_NUM_IN_CACHE = 10000000;
    public static final boolean CACHE_EMPTY = false;
    public static final boolean CACHING_FINISHED = true;
    public static final int IS_PRIME = 1;
    public static final int IS_NOT_PRIME = 0;
    public static final int NOT_IN_CACHE = -1;
    int maxNumInCache;
    int numberOfPrimes;
    double computingTime;
    boolean cacheStatus;
    boolean[] isPrime;

    private void EratosthenesSieve() {
        int i;
        this.isPrime = new boolean[this.maxNumInCache + 1];
        this.numberOfPrimes = 0;
        long startTime = System.currentTimeMillis();
        this.isPrime[0] = false;
        this.isPrime[1] = false;
        for (i = 2; i <= this.maxNumInCache; ++i) {
            this.isPrime[i] = true;
        }
        i = 2;
        while (i * i <= this.maxNumInCache) {
            if (this.isPrime[i]) {
                int j = i;
                while (i * j <= this.maxNumInCache) {
                    this.isPrime[i * j] = false;
                    ++j;
                }
            }
            ++i;
        }
        long endTime = System.currentTimeMillis();
        this.computingTime = (double)(endTime - startTime) / 1000.0;
    }

    private void countPrimes() {
        for (int i = 0; i <= this.maxNumInCache; ++i) {
            if (!this.isPrime[i]) continue;
            ++this.numberOfPrimes;
        }
    }

    public PrimesCache() {
        this.cacheStatus = false;
        this.maxNumInCache = 10000000;
        this.EratosthenesSieve();
        this.countPrimes();
        this.cacheStatus = true;
    }

    public PrimesCache(int maxNumInCache) {
        this.maxNumInCache = maxNumInCache > 2 ? maxNumInCache : 10000000;
        this.cacheStatus = false;
        maxNumInCache = 10000000;
        this.EratosthenesSieve();
        this.countPrimes();
        this.cacheStatus = true;
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    public boolean getCacheStatus() {
        return this.cacheStatus;
    }

    public int getNumberOfPrimes() {
        return this.numberOfPrimes;
    }

    public int getMaxNumInCache() {
        return this.maxNumInCache;
    }

    public int primeTest(int n) {
        if (n <= this.maxNumInCache) {
            this.cacheStatus = true;
            if (true) {
                if (this.isPrime[n]) {
                    return 1;
                }
                return 0;
            }
        }
        return -1;
    }

    boolean[] getPrimes() {
        return this.isPrime;
    }
}

