/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    public static final ItemStack EMPTY = ItemStack.field_190927_a;

    private ItemStackUtils() {
    }

    public static List<ItemStack> getItemStacksOfTileEntity(CompoundNBT compound, World world) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        TileEntity tileEntity = TileEntity.func_203403_c((CompoundNBT)compound);
        if (tileEntity instanceof LockableTileEntity) {
            for (int i = 0; i < ((LockableTileEntity)tileEntity).func_70302_i_(); ++i) {
                ItemStack stack = ((LockableTileEntity)tileEntity).func_70301_a(i);
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    @NotNull
    public static Boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack == EMPTY || stack.func_190916_E() <= 0;
    }

    public static int getSize(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.func_190916_E();
    }

    public static List<ItemStack> getListOfStackForEntity(Entity entity, BlockPos pos) {
        if (entity != null) {
            ArrayList<ItemStack> request = new ArrayList<ItemStack>();
            if (entity instanceof ItemFrameEntity) {
                ItemStack stack2 = ((ItemFrameEntity)entity).func_82335_i();
                if (!ItemStackUtils.isEmpty(stack2).booleanValue()) {
                    stack2.func_190920_e(1);
                    request.add(stack2);
                }
                request.add(new ItemStack((IItemProvider)Items.field_151160_bD, 1));
            } else if (entity instanceof ArmorStandEntity) {
                request.add(entity.getPickedResult(new RayTraceResult(new Vec3d((Vec3i)pos)){

                    @NotNull
                    public RayTraceResult.Type func_216346_c() {
                        return RayTraceResult.Type.ENTITY;
                    }
                }));
                entity.func_184193_aE().forEach(request::add);
                entity.func_184214_aD().forEach(request::add);
            }
            return request.stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

