/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.client.gui.WindowShapeTool;
import com.ldtteam.structurize.network.messages.ReplaceBlockMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WindowReplaceBlock
extends Window
implements ButtonHandler {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String INPUT_NAME = "name";
    private static final String WINDOW_REPLACE_BLOCK = ":gui/windowreplaceblock.xml";
    private final ItemStack from;
    private final BlockPos pos1;
    private static final int WHITE = Color.getByName("white", 0);
    private final BlockPos pos2;
    private final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private final ScrollingList resourceList;
    private String filter = "";
    private final boolean mainBlock;
    private final Window origin;

    public WindowReplaceBlock(@NotNull ItemStack initialStack, BlockPos pos1, BlockPos pos2, Window origin) {
        super("structurize:gui/windowreplaceblock.xml");
        this.from = initialStack;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.mainBlock = false;
        this.resourceList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.origin = origin;
    }

    public WindowReplaceBlock(@NotNull ItemStack initialStack, BlockPos pos, boolean main, Window origin) {
        super("structurize:gui/windowreplaceblock.xml");
        this.from = initialStack;
        this.pos1 = pos;
        this.pos2 = BlockPos.field_177992_a;
        this.mainBlock = main;
        this.resourceList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.origin = origin;
    }

    @Override
    public void onOpened() {
        this.findPaneOfTypeByID("resourceIconFrom", ItemIcon.class).setItem(this.from);
        this.findPaneOfTypeByID("resourceNameFrom", Label.class).setLabelText(this.from.func_200301_q().func_150261_e());
        this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class).setItem(new ItemStack((IItemProvider)Blocks.field_150350_a));
        this.findPaneOfTypeByID("resourceNameTo", Label.class).setLabelText(new ItemStack((IItemProvider)Blocks.field_150350_a).func_200301_q().func_150261_e());
        this.updateResources();
    }

    private void updateResources() {
        this.allItems.clear();
        this.allItems.addAll((Collection<ItemStack>)ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(ForgeRegistries.ITEMS.iterator(), 16), false).map(ItemStack::new).filter(stack -> stack.func_77973_b() instanceof BlockItem && (this.filter.isEmpty() || stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)))).collect(Collectors.toList())));
        ArrayList<ItemStack> specialBlockList = new ArrayList<ItemStack>();
        specialBlockList.add(new ItemStack((IItemProvider)Items.field_151131_as));
        specialBlockList.add(new ItemStack((IItemProvider)Items.field_151129_at));
        specialBlockList.add(new ItemStack((IItemProvider)Items.field_151117_aB));
        this.allItems.addAll(specialBlockList.stream().filter(stack -> this.filter.isEmpty() || stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.func_200301_q().func_150261_e().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))).collect(Collectors.toList()));
        this.updateResourceList();
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        String name = this.findPaneOfTypeByID(INPUT_NAME, TextField.class).getText();
        if (!name.isEmpty()) {
            this.filter = name;
        }
        this.updateResources();
        return result;
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals(BUTTON_DONE)) {
            ItemStack to = this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class).getItem();
            if (!ItemStackUtils.isEmpty(to).booleanValue()) {
                if (this.origin instanceof WindowScan) {
                    Network.getNetwork().sendToServer(new ReplaceBlockMessage(this.pos1, this.pos2, this.from, to));
                } else {
                    new WindowShapeTool(this.pos1, to, this.mainBlock).open();
                }
                this.origin.open();
            }
        } else if (button.getID().equals(BUTTON_CANCEL)) {
            this.origin.open();
        } else if (button.getID().equals("select")) {
            int row = this.resourceList.getListElementIndexByPane(button);
            ItemStack to = this.allItems.get(row);
            this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class).setItem(to);
            this.findPaneOfTypeByID("resourceNameTo", Label.class).setLabelText(to.func_200301_q().func_150261_e());
        }
    }

    public void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<ItemStack> tempRes = new ArrayList<ItemStack>(this.allItems);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return tempRes.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)tempRes.get(index);
                Label resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Label.class);
                resourceLabel.setLabelText(resource.func_200301_q().func_150261_e());
                resourceLabel.setColor(WHITE, WHITE);
                rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(resource);
            }
        });
    }
}

