/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.commands.arguments.MultipleStringArgument;
import com.ldtteam.structurize.management.linksession.ChannelsEnum;
import com.ldtteam.structurize.management.linksession.LinkSessionManager;
import com.ldtteam.structurize.util.LanguageHandler;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.command.arguments.MessageArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class LinkSessionCommand {

    protected static class Leave
    extends AbstractCommand {
        private static final String NAME = "leave";
        private static final String TARGET_ARG = "targets";

        protected Leave() {
        }

        protected static LiteralArgumentBuilder<CommandSource> build() {
            return (LiteralArgumentBuilder)Leave.newLiteral(NAME).then(Leave.newArgument(TARGET_ARG, MultipleStringArgument.multipleString((s, p) -> LinkSessionManager.INSTANCE.getSessionNamesOf(p.func_110124_au()))).executes(s -> Leave.onExecute((CommandContext<CommandSource>)s)));
        }

        private static int onExecute(CommandContext<CommandSource> command) throws CommandSyntaxException {
            ServerPlayerEntity sender = ((CommandSource)command.getSource()).func_197035_h();
            MinecraftServer server = ((CommandSource)command.getSource()).func_197028_i();
            String name = MultipleStringArgument.getResult(command, TARGET_ARG);
            if (server.func_184103_al().func_152612_a(name) != null) {
                LinkSessionManager.INSTANCE.removeMemberOfSession(server.func_184103_al().func_152612_a(name).func_110124_au(), sender.func_110124_au());
                sender.func_145747_a((ITextComponent)new StringTextComponent("Leaving a session owned by \"" + name + "\"."));
            }
            return 1;
        }
    }

    protected static class AcceptInvite
    extends AbstractCommand {
        private static final String NAME = "acceptinvite";
        private static final String UUID_ARG = "targets";

        protected AcceptInvite() {
        }

        protected static LiteralArgumentBuilder<CommandSource> build() {
            return (LiteralArgumentBuilder)((LiteralArgumentBuilder)AcceptInvite.newLiteral(NAME).executes(s -> AcceptInvite.onExecute((CommandContext<CommandSource>)s, false))).then(AcceptInvite.newArgument(UUID_ARG, MessageArgument.func_197123_a()).executes(s -> AcceptInvite.onExecute((CommandContext<CommandSource>)s, true)));
        }

        private static int onExecute(CommandContext<CommandSource> command, boolean withUUID) throws CommandSyntaxException {
            ServerPlayerEntity sender = ((CommandSource)command.getSource()).func_197035_h();
            UUID senderUUID = sender.func_110124_au();
            String ownerName = null;
            if (withUUID) {
                try {
                    ownerName = LinkSessionManager.INSTANCE.consumeInviteWithCheck(senderUUID, sender.func_146103_bH().getName(), UUID.fromString(MessageArgument.func_197124_a(command, (String)UUID_ARG).func_150261_e()));
                }
                catch (IllegalArgumentException e) {
                    AcceptInvite.throwSyntaxException("Unexpected error");
                }
                if (ownerName == null) {
                    AcceptInvite.throwSyntaxException("structurize.command.ls.invite.timeout");
                }
            } else {
                ownerName = LinkSessionManager.INSTANCE.consumeInvite(senderUUID, sender.func_146103_bH().getName());
                if (ownerName == null) {
                    AcceptInvite.throwSyntaxException("structurize.command.ls.invite.noopen");
                }
            }
            sender.func_145747_a(LanguageHandler.buildChatComponent("structurize.command.ls.invite.accepted", ownerName));
            return 1;
        }
    }

    protected static class MuteChannel
    extends AbstractCommand {
        private static final String NAME = "mutechannel";

        protected MuteChannel() {
        }

        protected static LiteralArgumentBuilder<CommandSource> build() {
            LiteralArgumentBuilder<CommandSource> root = MuteChannel.newLiteral(NAME);
            for (ChannelsEnum ch : ChannelsEnum.values()) {
                root.then(MuteChannel.newLiteral(ch.getCommandName()).executes(s -> MuteChannel.onExecute((CommandContext<CommandSource>)s, ch)));
            }
            return root;
        }

        public List<String> getTabCompletions() {
            return Stream.of(ChannelsEnum.values()).map(ch -> ch.getCommandName()).collect(Collectors.toList());
        }

        private static int onExecute(CommandContext<CommandSource> command, ChannelsEnum ch) throws CommandSyntaxException {
            ServerPlayerEntity sender = ((CommandSource)command.getSource()).func_197035_h();
            UUID senderUUID = sender.func_110124_au();
            if (ch != null) {
                LinkSessionManager.INSTANCE.setMuteState(senderUUID, ch, !LinkSessionManager.INSTANCE.getMuteState(senderUUID, ch));
            }
            return 1;
        }
    }

    protected static class AboutMe
    extends AbstractCommand {
        private static final String NAME = "aboutme";

        protected AboutMe() {
        }

        protected static LiteralArgumentBuilder<CommandSource> build() {
            return (LiteralArgumentBuilder)AboutMe.newLiteral(NAME).executes(s -> AboutMe.onExecute((CommandContext<CommandSource>)s));
        }

        private static int onExecute(CommandContext<CommandSource> command) throws CommandSyntaxException {
            ServerPlayerEntity sender = ((CommandSource)command.getSource()).func_197035_h();
            UUID senderUUID = sender.func_110124_au();
            List<String> ownerSession = LinkSessionManager.INSTANCE.getMembersNamesOf(senderUUID);
            sender.func_145747_a((ITextComponent)new StringTextComponent("Info about \"" + sender.func_146103_bH().getName() + "\":"));
            String ownerName = LinkSessionManager.INSTANCE.hasInvite(senderUUID);
            if (ownerName == null) {
                sender.func_145747_a((ITextComponent)new StringTextComponent("  \u00a7cYou have no open invite."));
            } else {
                sender.func_145747_a((ITextComponent)new StringTextComponent("  \u00a7aYou have an open invite from " + ownerName + "."));
            }
            if (ownerSession == null) {
                sender.func_145747_a((ITextComponent)new StringTextComponent("  \u00a7cYou don't have your own session."));
            } else {
                sender.func_145747_a((ITextComponent)new StringTextComponent("  \u00a7aYou own a session with:"));
                for (String name : ownerSession) {
                    if (!name.equals("null")) {
                        sender.func_145747_a((ITextComponent)new StringTextComponent("    \u00a77" + name));
                        continue;
                    }
                    sender.func_145747_a((ITextComponent)new StringTextComponent("    \u00a77Unknown name"));
                }
            }
            ownerSession = LinkSessionManager.INSTANCE.getSessionNamesOf(senderUUID);
            if (ownerSession == null) {
                sender.func_145747_a((ITextComponent)new StringTextComponent("  \u00a7cYou are not a part of other sessions."));
            } else {
                sender.func_145747_a((ITextComponent)new StringTextComponent("  \u00a7aYou are in sessions owned by:"));
                for (String name : ownerSession) {
                    sender.func_145747_a((ITextComponent)new StringTextComponent("    \u00a77" + name));
                }
            }
            sender.func_145747_a((ITextComponent)new StringTextComponent("  \u00a7aChannels:"));
            for (ChannelsEnum ch : ChannelsEnum.values()) {
                if (LinkSessionManager.INSTANCE.getMuteState(senderUUID, ch)) {
                    sender.func_145747_a((ITextComponent)new StringTextComponent(String.format("    \u00a77%s:\u00a7r \u00a7c%s", ch.getCommandName(), "muted")));
                    continue;
                }
                sender.func_145747_a((ITextComponent)new StringTextComponent(String.format("    \u00a77%s:\u00a7r \u00a7a%s", ch.getCommandName(), "unmuted")));
            }
            return 1;
        }
    }

    protected static class SendMessage
    extends AbstractCommand {
        private static final String NAME = "sendmessage";
        private static final String MESSAGE_ARG = "message";

        protected SendMessage() {
        }

        protected static LiteralArgumentBuilder<CommandSource> build() {
            return (LiteralArgumentBuilder)SendMessage.newLiteral(NAME).then(SendMessage.newArgument(MESSAGE_ARG, MessageArgument.func_197123_a()).executes(s -> SendMessage.onExecute((CommandContext<CommandSource>)s)));
        }

        private static int onExecute(CommandContext<CommandSource> command) throws CommandSyntaxException {
            ServerPlayerEntity sender = ((CommandSource)command.getSource()).func_197035_h();
            MinecraftServer server = ((CommandSource)command.getSource()).func_197028_i();
            UUID senderUUID = sender.func_110124_au();
            Set<UUID> uniqueMembers = LinkSessionManager.INSTANCE.execute(senderUUID, ChannelsEnum.COMMAND_MESSAGE);
            TranslationTextComponent msgWithHead = new TranslationTextComponent("commands.message.display.incoming", new Object[]{LanguageHandler.buildChatComponent("structurize.command.ls.message.head", "Structurize", sender.func_146103_bH().getName()), MessageArgument.func_197124_a(command, (String)MESSAGE_ARG)});
            if (LinkSessionManager.INSTANCE.getMuteState(senderUUID, ChannelsEnum.COMMAND_MESSAGE)) {
                SendMessage.throwSyntaxException("structurize.command.ls.message.muted");
            }
            if (uniqueMembers.size() == 1) {
                SendMessage.throwSyntaxException("structurize.command.ls.message.norecipient");
            }
            msgWithHead.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true));
            uniqueMembers.forEach(member -> {
                ServerPlayerEntity target = server.func_184103_al().func_177451_a(member);
                if (target != null) {
                    target.func_145747_a((ITextComponent)msgWithHead);
                }
            });
            return uniqueMembers.size();
        }
    }

    protected static class RemovePlayer
    extends AbstractCommand {
        private static final String NAME = "removeplayer";
        private static final String TARGETS_ARG = "targets";

        protected RemovePlayer() {
        }

        protected static LiteralArgumentBuilder<CommandSource> build() {
            return (LiteralArgumentBuilder)RemovePlayer.newLiteral(NAME).then(RemovePlayer.newArgument(TARGETS_ARG, GameProfileArgument.func_197108_a()).executes(s -> RemovePlayer.onExecute((CommandContext<CommandSource>)s)));
        }

        private static int onExecute(CommandContext<CommandSource> command) throws CommandSyntaxException {
            ServerPlayerEntity sender = ((CommandSource)command.getSource()).func_197035_h();
            MinecraftServer server = ((CommandSource)command.getSource()).func_197028_i();
            UUID ownerUUID = sender.func_110124_au();
            if (LinkSessionManager.INSTANCE.getMembersOf(ownerUUID) == null) {
                RemovePlayer.throwSyntaxException("structurize.command.ls.generic.dontexist");
            }
            int timesSucceeded = 0;
            for (GameProfile gp : GameProfileArgument.func_197109_a(command, (String)TARGETS_ARG)) {
                String name = gp.getName();
                ServerPlayerEntity target = server.func_184103_al().func_152612_a(name);
                if (target == null) continue;
                LinkSessionManager.INSTANCE.removeMemberOfSession(ownerUUID, target.func_110124_au());
                sender.func_145747_a(LanguageHandler.buildChatComponent("structurize.command.ls.remove.done", name, sender.func_146103_bH().getName()));
                ++timesSucceeded;
            }
            return timesSucceeded;
        }
    }

    protected static class AddPlayer
    extends AbstractCommand {
        private static final String NAME = "addplayer";
        private static final String TARGETS_ARG = "targets";

        protected AddPlayer() {
        }

        protected static LiteralArgumentBuilder<CommandSource> build() {
            return (LiteralArgumentBuilder)AddPlayer.newLiteral(NAME).then(AddPlayer.newArgument(TARGETS_ARG, GameProfileArgument.func_197108_a()).executes(s -> AddPlayer.onExecute((CommandContext<CommandSource>)s)));
        }

        private static int onExecute(CommandContext<CommandSource> command) throws CommandSyntaxException {
            ServerPlayerEntity sender = ((CommandSource)command.getSource()).func_197035_h();
            MinecraftServer server = ((CommandSource)command.getSource()).func_197028_i();
            UUID ownerUUID = sender.func_110124_au();
            ITextComponent acceptButton = LanguageHandler.buildChatComponent("structurize.command.ls.invite.accept", new Object[0]);
            ITextComponent inviteMsg = LanguageHandler.buildChatComponent("structurize.command.ls.invite.message", sender.func_146103_bH().getName());
            acceptButton.func_150256_b().func_150238_a(TextFormatting.DARK_RED).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/structurize linksession acceptinvite " + ownerUUID.toString()));
            inviteMsg.func_150257_a(acceptButton);
            if (LinkSessionManager.INSTANCE.getMembersOf(ownerUUID) == null) {
                AddPlayer.throwSyntaxException("structurize.command.ls.generic.dontexist");
            }
            int timesSucceeded = 0;
            for (GameProfile gp : GameProfileArgument.func_197109_a(command, (String)TARGETS_ARG)) {
                String name = gp.getName();
                ServerPlayerEntity target = server.func_184103_al().func_152612_a(name);
                if (target == null) continue;
                LinkSessionManager.INSTANCE.createInvite(target.func_110124_au(), ownerUUID);
                target.func_145747_a(inviteMsg);
                sender.func_145747_a(LanguageHandler.buildChatComponent("structurize.command.ls.invite.done", name, sender.func_146103_bH().getName()));
                ++timesSucceeded;
            }
            return timesSucceeded;
        }
    }

    protected static class Destroy
    extends AbstractCommand {
        private static final String NAME = "destroy";

        protected Destroy() {
        }

        protected static LiteralArgumentBuilder<CommandSource> build() {
            return (LiteralArgumentBuilder)Destroy.newLiteral(NAME).executes(s -> Destroy.onExecute((CommandContext<CommandSource>)s));
        }

        private static int onExecute(CommandContext<CommandSource> command) throws CommandSyntaxException {
            ServerPlayerEntity sender = ((CommandSource)command.getSource()).func_197035_h();
            UUID ownerUUID = sender.func_110124_au();
            if (LinkSessionManager.INSTANCE.destroySession(ownerUUID)) {
                sender.func_145747_a(LanguageHandler.buildChatComponent("structurize.command.ls.destroy.done", sender.func_146103_bH().getName()));
            } else {
                Destroy.throwSyntaxException("structurize.command.ls.generic.dontexist");
            }
            return 1;
        }
    }

    protected static class Create
    extends AbstractCommand {
        private static final String NAME = "create";

        protected Create() {
        }

        protected static LiteralArgumentBuilder<CommandSource> build() {
            return (LiteralArgumentBuilder)Create.newLiteral(NAME).executes(s -> Create.onExecute((CommandContext<CommandSource>)s));
        }

        private static int onExecute(CommandContext<CommandSource> command) throws CommandSyntaxException {
            ServerPlayerEntity sender = ((CommandSource)command.getSource()).func_197035_h();
            UUID ownerUUID = sender.func_110124_au();
            if (LinkSessionManager.INSTANCE.getMembersOf(ownerUUID) != null) {
                Create.throwSyntaxException("structurize.command.ls.create.already");
            }
            LinkSessionManager.INSTANCE.createSession(ownerUUID);
            LinkSessionManager.INSTANCE.addOrUpdateMemberInSession(ownerUUID, ownerUUID, sender.func_146103_bH().getName());
            sender.func_145747_a(LanguageHandler.buildChatComponent("structurize.command.ls.create.done", sender.func_146103_bH().getName()));
            return 1;
        }
    }
}

