/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.floating_carpets;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.recipes.RecipeIngredientJson;
import com.ldtteam.datagenerators.recipes.RecipeIngredientKeyJson;
import com.ldtteam.datagenerators.recipes.RecipeResultJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedPatternJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedRecipeJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockFloatingCarpet;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import com.ldtteam.structurize.items.ModItems;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.jetbrains.annotations.NotNull;

public class FloatingCarpetsRecipeProvider
implements IDataProvider {
    private final DataGenerator generator;

    public FloatingCarpetsRecipeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path inputPath = this.generator.func_200389_a().stream().findFirst().orElse(null);
        if (inputPath == null) {
            return;
        }
        for (BlockFloatingCarpet floatingCarpet : ModBlocks.getFloatingCarpets()) {
            this.createBaseCarpetRecipe(cache, floatingCarpet);
            this.createDyingCarpetRecipe(cache, floatingCarpet);
        }
    }

    @NotNull
    public String func_200397_b() {
        return "Floating Carpet Recipes";
    }

    private void createBaseCarpetRecipe(DirectoryCache cache, BlockFloatingCarpet floatingCarpet) throws IOException {
        if (floatingCarpet.getRegistryName() == null || ModItems.buildTool.getRegistryName() == null) {
            return;
        }
        ShapedRecipeJson recipeJson = new ShapedRecipeJson();
        recipeJson.setGroup("floating_carpet");
        recipeJson.setResult(new RecipeResultJson(1, floatingCarpet.getRegistryName().toString()));
        recipeJson.setPattern(new ShapedPatternJson(" B ", " C ", " S "));
        HashMap<String, RecipeIngredientKeyJson> ingredients = new HashMap<String, RecipeIngredientKeyJson>();
        ingredients.put("B", new RecipeIngredientKeyJson(new RecipeIngredientJson(ModItems.buildTool.getRegistryName().toString(), false)));
        ingredients.put("C", new RecipeIngredientKeyJson(new RecipeIngredientJson("minecraft:" + floatingCarpet.getColor().func_176762_d() + "_carpet", false)));
        ingredients.put("S", new RecipeIngredientKeyJson(new RecipeIngredientJson("minecraft:string", false)));
        recipeJson.setKey(ingredients);
        Path recipePath = this.generator.func_200391_b().resolve("data/structurize//recipes/").resolve(floatingCarpet.getRegistryName().func_110623_a() + ".json");
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)recipeJson), (Path)recipePath);
    }

    private void createDyingCarpetRecipe(DirectoryCache cache, BlockFloatingCarpet floatingCarpet) throws IOException {
        if (floatingCarpet.getRegistryName() == null || ModItems.buildTool.getRegistryName() == null) {
            return;
        }
        ShapedRecipeJson recipeJson = new ShapedRecipeJson();
        recipeJson.setGroup("floating_carpet");
        recipeJson.setResult(new RecipeResultJson(8, floatingCarpet.getRegistryName().toString()));
        recipeJson.setPattern(new ShapedPatternJson("CCC", "CDC", "CCC"));
        HashMap<String, RecipeIngredientKeyJson> ingredients = new HashMap<String, RecipeIngredientKeyJson>();
        ingredients.put("C", new RecipeIngredientKeyJson(new RecipeIngredientJson("structurize:floating_carpets", true)));
        ingredients.put("D", new RecipeIngredientKeyJson(new RecipeIngredientJson("minecraft:" + floatingCarpet.getColor().func_176762_d() + "_dye", false)));
        recipeJson.setKey(ingredients);
        Path recipePath = this.generator.func_200391_b().resolve("data/structurize//recipes/").resolve(floatingCarpet.getRegistryName().func_110623_a() + "_dying.json");
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)recipeJson), (Path)recipePath);
    }
}

