/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.shingle_slabs;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.models.block.BlockModelJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockShingleSlab;
import com.ldtteam.structurize.blocks.types.ShingleSlabShapeType;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.jetbrains.annotations.NotNull;

public class ShingleSlabsBlockModelProvider
implements IDataProvider {
    private final DataGenerator generator;

    public ShingleSlabsBlockModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path inputPath = this.generator.func_200389_a().stream().findFirst().orElse(null);
        if (inputPath == null) {
            return;
        }
        for (BlockShingleSlab shingleSlab : ModBlocks.getShingleSlabs()) {
            for (ShingleSlabShapeType shingleSlabShape : BlockShingleSlab.SHAPE.func_177700_c()) {
                if (shingleSlab.getRegistryName() == null) continue;
                File modelFile = inputPath.resolve("assets/structurize/models/block/shingle_slab/shingle_slab_" + shingleSlabShape.func_176610_l() + ".json").toFile();
                FileReader reader = new FileReader(modelFile);
                BlockModelJson modelJson = new BlockModelJson();
                modelJson.deserialize(new JsonParser().parse((Reader)reader));
                modelJson.setAmbientOcclusion(false);
                HashMap<String, String> textures = modelJson.getTextures();
                if (textures == null) {
                    textures = new HashMap<String, String>();
                }
                textures.put("1", shingleSlab.getFaceType().getTexture(1));
                textures.put("2", shingleSlab.getFaceType().getTexture(2));
                textures.put("3", shingleSlab.getFaceType().getTexture(3));
                textures.put("particle", shingleSlab.getFaceType().getTexture(1));
                modelJson.setTextures(textures);
                Path saveFile = this.generator.func_200391_b().resolve("assets/structurize/models/block/shingle_slab/" + shingleSlab.getRegistryName().func_110623_a() + "_" + shingleSlabShape.func_176610_l() + ".json");
                IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)modelJson), (Path)saveFile);
            }
        }
    }

    @NotNull
    public String func_200397_b() {
        return "Shingle Slabs Block Model Provider";
    }
}

