/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateAndPasteMessage
implements IMessage {
    private boolean hollow;
    private ItemStack block;
    private ItemStack block2;
    private Shape shape;
    private BlockPos pos;
    private int length;
    private int width;
    private int height;
    private int frequency;
    private String equation;
    private int rotation;
    private boolean mirror;

    public GenerateAndPasteMessage() {
    }

    public GenerateAndPasteMessage(@NotNull BlockPos pos, int length, int width, int height, int frequency, String equation, Shape shape, ItemStack block, ItemStack block2, boolean hollow, Rotation rotation, Mirror mirror) {
        this.pos = pos;
        this.length = length;
        this.width = width;
        this.height = height;
        this.frequency = frequency;
        this.shape = shape;
        this.block = block;
        this.block2 = block2;
        this.hollow = hollow;
        this.mirror = mirror != Mirror.NONE;
        this.rotation = rotation.ordinal();
        this.equation = equation;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.length = buf.readInt();
        this.width = buf.readInt();
        this.height = buf.readInt();
        this.frequency = buf.readInt();
        this.shape = Shape.values()[buf.readInt()];
        this.block = buf.func_150791_c();
        this.block2 = buf.func_150791_c();
        this.hollow = buf.readBoolean();
        this.rotation = buf.readInt();
        this.mirror = buf.readBoolean();
        this.equation = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.length);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
        buf.writeInt(this.frequency);
        buf.writeInt(this.shape.ordinal());
        buf.func_150788_a(this.block);
        buf.func_150788_a(this.block2);
        buf.writeBoolean(this.hollow);
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.mirror);
        buf.func_180714_a(this.equation);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().func_184812_l_()) {
            return;
        }
        Manager.pasteStructure(ctxIn.getSender().func_71121_q(), this.pos, this.width, this.length, this.height, this.frequency, this.equation, this.shape, this.block, this.block2, this.hollow, ctxIn.getSender(), this.mirror ? Mirror.FRONT_BACK : Mirror.NONE, Rotation.values()[this.rotation]);
    }
}

