/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructurizeStylesMessage
implements IMessage {
    private boolean allowPlayerSchematics;
    private Map<String, String> md5Map;

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.allowPlayerSchematics = buf.readBoolean();
        this.md5Map = StructurizeStylesMessage.readMD5MapFromByteBuf(buf);
    }

    @NotNull
    private static Map<String, String> readMD5MapFromByteBuf(@NotNull PacketBuffer buf) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            String filename = buf.func_150789_c(Short.MAX_VALUE);
            String md5 = buf.func_150789_c(Short.MAX_VALUE);
            map.put(filename, md5);
        }
        return map;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeBoolean(((Boolean)Structurize.getConfig().getCommon().allowPlayerSchematics.get()).booleanValue());
        StructurizeStylesMessage.writeMD5MapToByteBuf(buf);
    }

    private static void writeMD5MapToByteBuf(@NotNull PacketBuffer buf) {
        Map<String, String> md5s = Structures.getMD5s();
        buf.writeInt(md5s.size());
        for (Map.Entry<String, String> entry : md5s.entrySet()) {
            buf.func_180714_a(entry.getKey());
            buf.func_180714_a(entry.getValue());
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        Structures.init();
        Structures.setAllowPlayerSchematics(this.allowPlayerSchematics);
        Structures.setMD5s(this.md5Map);
    }
}

