/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.handlers.placement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public class PlacementError {
    private PlacementErrorType type;
    private BlockPos pos;

    public PlacementError(PlacementErrorType type, BlockPos pos) {
        this.type = type;
        this.pos = pos;
    }

    public PlacementErrorType getType() {
        return this.type;
    }

    public void setType(PlacementErrorType type) {
        this.type = type;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public static String blockListToCommaSeparatedString(List<BlockPos> blocksToReportList) {
        StringBuilder outputListStringBuilder = new StringBuilder();
        boolean firstItem = true;
        for (BlockPos blockPos : blocksToReportList) {
            if (firstItem) {
                firstItem = false;
            } else {
                outputListStringBuilder.append(", ");
            }
            outputListStringBuilder.append('(');
            outputListStringBuilder.append(blockPos.func_177958_n());
            outputListStringBuilder.append(' ');
            outputListStringBuilder.append(blockPos.func_177956_o());
            outputListStringBuilder.append(' ');
            outputListStringBuilder.append(blockPos.func_177952_p());
            outputListStringBuilder.append(')');
        }
        return outputListStringBuilder.toString();
    }

    public static Map<PlacementErrorType, List<BlockPos>> partitionPlacementErrorsByErrorType(List<PlacementError> placementErrorList) {
        EnumMap<PlacementErrorType, List<BlockPos>> blockPosListByErrorTypeMap = new EnumMap<PlacementErrorType, List<BlockPos>>(PlacementErrorType.class);
        for (PlacementError placementError : placementErrorList) {
            PlacementErrorType key = placementError.getType();
            BlockPos blockPos = placementError.getPos();
            ArrayList<BlockPos> blockPosList = blockPosListByErrorTypeMap.computeIfAbsent(key, k -> Lists.newArrayList());
            if (null == blockPosList) {
                blockPosList = new ArrayList<BlockPos>();
                blockPosListByErrorTypeMap.put(key, blockPosList);
            }
            blockPosList.add(blockPos);
        }
        return blockPosListByErrorTypeMap;
    }

    public static enum PlacementErrorType {
        NOT_SOLID,
        INSIDE_COLONY,
        NEEDS_AIR_ABOVE,
        NOT_WATER;

    }
}

