/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.proxy;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.client.gui.WindowMultiBlock;
import com.ldtteam.structurize.client.gui.WindowPlaceholderblock;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.client.gui.WindowShapeTool;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.proxy.CommonProxy;
import java.io.File;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientProxy
extends CommonProxy {
    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void openBuildToolWindow(@Nullable BlockPos pos) {
        if (pos == null && Settings.instance.getActiveStructure() == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof Screen) {
            return;
        }
        WindowBuildTool window = new WindowBuildTool(pos);
        window.open();
    }

    @Override
    public void openShapeToolWindow(@Nullable BlockPos pos) {
        if (pos == null && Settings.instance.getActiveStructure() == null) {
            return;
        }
        WindowShapeTool window = new WindowShapeTool(pos);
        window.open();
    }

    @Override
    public void openScanToolWindow(@Nullable BlockPos pos1, @Nullable BlockPos pos2, Optional<BlockPos> anchorPos) {
        if (pos1 == null || pos2 == null) {
            return;
        }
        WindowScan window = new WindowScan(pos1, pos2, anchorPos);
        window.open();
    }

    @Override
    public void openBuildToolWindow(BlockPos pos, String structureName, int rotation) {
        if (pos == null && Settings.instance.getActiveStructure() == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof Screen) {
            return;
        }
        WindowBuildTool window = new WindowBuildTool(pos, structureName, rotation);
        window.open();
    }

    @Override
    public File getSchematicsFolder() {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            if (Manager.getServerUUID() != null) {
                return new File(Minecraft.func_71410_x().field_71412_D, "structurize/" + Manager.getServerUUID());
            }
            Log.getLogger().error("Manager.getServerUUID() => null this should not happen");
            return null;
        }
        File worldSchematicFolder = new File(ServerLifecycleHooks.getCurrentServer().func_71238_n() + "/" + "structurize" + '/' + "schematics");
        if (!worldSchematicFolder.exists()) {
            return new File(Minecraft.func_71410_x().field_71412_D, "structurize");
        }
        return worldSchematicFolder.getParentFile();
    }

    @Override
    @Nullable
    public World getWorld(int dimension) {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    @NotNull
    public RecipeBook getRecipeBookFromPlayer(@NotNull PlayerEntity player) {
        if (player instanceof ClientPlayerEntity) {
            return ((ClientPlayerEntity)player).func_199507_B();
        }
        return super.getRecipeBookFromPlayer(player);
    }

    @Override
    public void openMultiBlockWindow(@Nullable BlockPos pos) {
        WindowMultiBlock window = new WindowMultiBlock(pos);
        window.open();
    }

    @Override
    public void openPlaceholderBlockWindow(@Nullable BlockPos pos) {
        WindowPlaceholderblock window = new WindowPlaceholderblock(pos);
        window.open();
    }
}

