/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APReferences;
import cofh.core.util.Utils;
import cofh.core.util.references.CoreReferences;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EnderArrowEntity
extends AbstractArrowEntity {
    private static float baseDamage = 0.5f;
    private static final int DURATION = 80;
    private static final int DURATION_FACTOR = 2;
    public boolean discharged;
    private BlockPos origin;

    public EnderArrowEntity(EntityType<? extends EnderArrowEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
        this.field_70255_ao = baseDamage;
    }

    public EnderArrowEntity(World worldIn, LivingEntity shooter) {
        super(APReferences.ENDER_ARROW_ENTITY, shooter, worldIn);
        this.field_70255_ao = baseDamage;
        this.origin = shooter.func_180425_c();
    }

    public EnderArrowEntity(World worldIn, double x, double y, double z) {
        super(APReferences.ENDER_ARROW_ENTITY, x, y, z, worldIn);
        this.field_70255_ao = baseDamage;
        this.origin = new BlockPos(x, y, z);
    }

    protected ItemStack func_184550_j() {
        return this.discharged ? new ItemStack((IItemProvider)Items.field_151032_g) : new ItemStack((IItemProvider)APReferences.ENDER_ARROW_ITEM);
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        super.func_184549_a(raytraceResultIn);
        Entity shooter = this.func_212360_k();
        if (raytraceResultIn.func_216346_c() != RayTraceResult.Type.MISS && !this.discharged && shooter != null) {
            int duration = Math.max(80, this.field_70257_an * 2);
            if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.BLOCK) {
                Utils.teleportEntityTo((Entity)shooter, (BlockPos)this.func_180425_c());
                if (shooter instanceof LivingEntity && !Utils.isFakePlayer((Entity)shooter)) {
                    ((LivingEntity)shooter).func_195064_c(new EffectInstance(CoreReferences.ENDERFERENCE, duration, 0, false, false));
                }
            }
            if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity;
                BlockPos originPos = this.origin == null ? shooter.func_180425_c() : this.origin;
                Utils.teleportEntityTo((Entity)shooter, (BlockPos)this.func_180425_c());
                if (shooter instanceof LivingEntity && !Utils.isFakePlayer((Entity)shooter)) {
                    ((LivingEntity)shooter).func_195064_c(new EffectInstance(CoreReferences.ENDERFERENCE, duration, 0, false, false));
                }
                if ((entity = ((EntityRayTraceResult)raytraceResultIn).func_216348_a()) instanceof LivingEntity && entity.func_184222_aU()) {
                    Utils.teleportEntityTo((Entity)entity, (BlockPos)originPos);
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(CoreReferences.ENDERFERENCE, duration, 0, false, false));
                }
            }
            this.discharged = true;
        }
    }

    public void func_70015_d(int seconds) {
    }

    public void func_70243_d(boolean critical) {
    }

    public void func_70240_a(int knockbackStrengthIn) {
    }

    public void func_213872_b(byte level) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if ((!this.field_70254_i || this.func_203047_q()) && Utils.isClientWorld((World)this.field_70170_p)) {
            Vec3d vec3d = this.func_213322_ci();
            double d1 = vec3d.field_72450_a;
            double d2 = vec3d.field_72448_b;
            double d0 = vec3d.field_72449_c;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + d1 * 0.25, this.func_226278_cu_() + d2 * 0.25, this.func_226281_cx_() + d0 * 0.25, -d1, -d2 + 0.2, -d0);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("ArrowData", this.discharged);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.discharged = compound.func_74767_n("ArrowData");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

