/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APReferences;
import cofh.core.util.AreaUtils;
import cofh.core.util.Utils;
import cofh.core.util.references.CoreReferences;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class FrostArrowEntity
extends AbstractArrowEntity {
    private static final int CLOUD_DURATION = 20;
    public static float baseDamage = 1.5f;
    public static int effectAmplifier = 1;
    public static int effectDuration = 100;
    public static int effectRadius = 4;
    public static boolean permanentLava = true;
    public static boolean permanentWater = true;
    public boolean discharged;

    public FrostArrowEntity(EntityType<? extends FrostArrowEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
        this.field_70255_ao = baseDamage;
    }

    public FrostArrowEntity(World worldIn, LivingEntity shooter) {
        super(APReferences.FROST_ARROW_ENTITY, shooter, worldIn);
        this.field_70255_ao = baseDamage;
    }

    public FrostArrowEntity(World worldIn, double x, double y, double z) {
        super(APReferences.FROST_ARROW_ENTITY, x, y, z, worldIn);
        this.field_70255_ao = baseDamage;
    }

    protected ItemStack func_184550_j() {
        return this.discharged ? new ItemStack((IItemProvider)Items.field_151032_g) : new ItemStack((IItemProvider)APReferences.FROST_ARROW_ITEM);
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        super.func_184549_a(raytraceResultIn);
        if (!this.discharged && raytraceResultIn.func_216346_c() != RayTraceResult.Type.MISS) {
            if (effectRadius > 0) {
                if (Utils.isServerWorld((World)this.field_70170_p)) {
                    AreaUtils.freezeNearbyGround((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_180425_c(), (int)effectRadius);
                    AreaUtils.freezeSurfaceWater((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_180425_c(), (int)effectRadius, (boolean)permanentWater);
                    AreaUtils.freezeSurfaceLava((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_180425_c(), (int)effectRadius, (boolean)permanentLava);
                    this.makeAreaOfEffectCloud();
                }
                this.discharged = true;
            }
            if (this.field_195056_av != null && this.field_195056_av.func_204520_s() != Fluids.field_204541_a.func_207188_f()) {
                this.field_70254_i = false;
                this.func_213317_d(this.func_213322_ci().func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            }
        }
    }

    protected void func_213868_a(EntityRayTraceResult raytraceResultIn) {
        super.func_213868_a(raytraceResultIn);
        Entity entity = raytraceResultIn.func_216348_a();
        if (entity.func_70027_ad()) {
            entity.func_70066_B();
        }
        if (!entity.func_190530_aW() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.func_195064_c(new EffectInstance(CoreReferences.CHILLED, effectDuration, effectAmplifier, false, false));
        }
    }

    public void func_70015_d(int seconds) {
    }

    public void func_70243_d(boolean critical) {
    }

    public void func_70240_a(int knockbackStrengthIn) {
    }

    public void func_213872_b(byte level) {
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        boolean flag = this.func_203047_q();
        Vec3d vec3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)FrostArrowEntity.func_213296_b((Vec3d)vec3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !flag) {
            if (this.field_195056_av != blockstate && this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_186662_g(0.06))) {
                this.field_70254_i = false;
                this.func_213317_d(vec3d.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_225516_i_();
            }
            ++this.field_184552_b;
        } else {
            Vec3d vec3d2;
            this.field_184552_b = 0;
            ++this.field_70257_an;
            Vec3d vec3d1 = new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d1, vec3d2 = vec3d1.func_178787_e(vec3d), RayTraceContext.BlockMode.COLLIDER, this.discharged ? RayTraceContext.FluidMode.NONE : RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vec3d2 = raytraceresult.func_216347_e();
            }
            while (this.func_70089_S()) {
                EntityRayTraceResult entityraytraceresult = this.func_213866_a(vec3d1, vec3d2);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.func_212360_k();
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && !flag && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
                    this.func_184549_a((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.func_213874_s() <= 0) break;
                raytraceresult = null;
            }
            vec3d = this.func_213322_ci();
            double d1 = vec3d.field_72450_a;
            double d2 = vec3d.field_72448_b;
            double d0 = vec3d.field_72449_c;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197593_D, this.func_226277_ct_() + d1 * 0.25, this.func_226278_cu_() + d2 * 0.25, this.func_226281_cx_() + d0 * 0.25, -d1, -d2 + 0.2, -d0);
            this.func_226288_n_(this.func_226277_ct_() + d1, this.func_226278_cu_() + d2, this.func_226281_cx_() + d0);
            float f4 = MathHelper.func_76133_a((double)FrostArrowEntity.func_213296_b((Vec3d)vec3d));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d1), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d2, (double)f4) * 57.2957763671875);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
            float f1 = 0.99f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - d1 * 0.25, this.func_226278_cu_() - d2 * 0.25, this.func_226281_cx_() - d0 * 0.25, d1, d2, d0);
                }
                f1 = this.func_203044_p();
            }
            this.func_213317_d(vec3d.func_186678_a((double)f1));
            if (!this.func_189652_ae() && !flag) {
                Vec3d vec3d3 = this.func_213322_ci();
                this.func_213293_j(vec3d3.field_72450_a, vec3d3.field_72448_b - 0.05, vec3d3.field_72449_c);
            }
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            this.func_145775_I();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("ArrowData", this.discharged);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.discharged = compound.func_74767_n("ArrowData");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        cloud.func_184483_a(1.0f);
        cloud.func_195059_a((IParticleData)ParticleTypes.field_197593_D);
        cloud.func_184486_b(20);
        cloud.func_184485_d(0);
        cloud.func_184487_c(((float)effectRadius - cloud.func_184490_j()) / (float)cloud.func_184489_o());
        this.field_70170_p.func_217376_c((Entity)cloud);
    }
}

