/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.init;

import cofh.archersparadox.entity.projectile.BlazeArrowEntity;
import cofh.archersparadox.entity.projectile.DiamondArrowEntity;
import cofh.archersparadox.entity.projectile.DisplacementArrowEntity;
import cofh.archersparadox.entity.projectile.ExplosiveArrowEntity;
import cofh.archersparadox.entity.projectile.FrostArrowEntity;
import cofh.archersparadox.entity.projectile.GlowstoneArrowEntity;
import cofh.archersparadox.entity.projectile.PrismarineArrowEntity;
import cofh.archersparadox.entity.projectile.QuartzArrowEntity;
import cofh.archersparadox.entity.projectile.RedstoneArrowEntity;
import cofh.archersparadox.entity.projectile.ShulkerArrowEntity;
import cofh.archersparadox.entity.projectile.SlimeArrowEntity;
import cofh.archersparadox.entity.projectile.SporeArrowEntity;
import cofh.archersparadox.entity.projectile.VerdantArrowEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class APConfig {
    private static boolean registered = false;
    private static final ForgeConfigSpec.Builder SERVER_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec.Builder CLIENT_CONFIG;
    private static ForgeConfigSpec clientSpec;
    public static ForgeConfigSpec.BooleanValue enableCreativeTab;
    private static ForgeConfigSpec.IntValue blazeArrowDuration;
    private static ForgeConfigSpec.IntValue blazeArrowRadius;
    private static ForgeConfigSpec.DoubleValue diamondArrowDamage;
    private static ForgeConfigSpec.IntValue diamondArrowKnockback;
    private static ForgeConfigSpec.IntValue diamondArrowPierce;
    private static ForgeConfigSpec.IntValue displacementArrowRadius;
    private static ForgeConfigSpec.DoubleValue explosiveArrowStrength;
    private static ForgeConfigSpec.BooleanValue explosiveArrowBreakBlocks;
    private static ForgeConfigSpec.BooleanValue explosiveArrowCauseFire;
    private static ForgeConfigSpec.BooleanValue explosiveArrowKnockbackBoost;
    private static ForgeConfigSpec.IntValue frostArrowRadius;
    private static ForgeConfigSpec.BooleanValue frostArrowPermanentLava;
    private static ForgeConfigSpec.BooleanValue frostArrowPermanentWater;
    private static ForgeConfigSpec.IntValue glowstoneArrowRadius;
    private static ForgeConfigSpec.DoubleValue prismarineArrowDamage;
    private static ForgeConfigSpec.IntValue prismarineArrowKnockback;
    private static ForgeConfigSpec.IntValue prismarineArrowPierce;
    private static ForgeConfigSpec.DoubleValue quartzArrowDamage;
    private static ForgeConfigSpec.IntValue quartzArrowKnockback;
    private static ForgeConfigSpec.IntValue quartzArrowPierce;
    private static ForgeConfigSpec.IntValue redstoneArrowRadius;
    private static ForgeConfigSpec.IntValue slimeArrowBounces;
    private static ForgeConfigSpec.IntValue slimeArrowKnockback;
    private static ForgeConfigSpec.BooleanValue slimeArrowKnockbackBoost;
    private static ForgeConfigSpec.IntValue shulkerArrowDuration;
    private static ForgeConfigSpec.IntValue sporeArrowRadius;
    private static ForgeConfigSpec.IntValue verdantArrowRadius;

    public static void register() {
        if (registered) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(APConfig.class);
        registered = true;
        APConfig.genServerConfig();
        APConfig.genClientConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    private APConfig() {
    }

    private static void genServerConfig() {
        APConfig.genArrowConfig();
        serverSpec = SERVER_CONFIG.build();
    }

    private static void genClientConfig() {
        enableCreativeTab = CLIENT_CONFIG.comment("If TRUE, Archer's Paradox will have its own Item Group (Creative Tab).").define("Enable Item Group", true);
        clientSpec = CLIENT_CONFIG.build();
    }

    private static void genArrowConfig() {
        SERVER_CONFIG.push("Arrows");
        SERVER_CONFIG.push("Blaze");
        blazeArrowDuration = SERVER_CONFIG.comment("Adjust this to set the burn duration for the Blaze Arrow (in seconds). Nearby targets will burn for 5 seconds less than a direct target.").defineInRange("Burn Duration", BlazeArrowEntity.effectDuration, 5, 30);
        blazeArrowRadius = SERVER_CONFIG.comment("Adjust this to set the effect radius for the Blaze Arrow. Set to 0 to disable, but that would be boring.").defineInRange("Radius", BlazeArrowEntity.effectRadius, 0, 16);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Diamond");
        diamondArrowDamage = SERVER_CONFIG.comment("Adjust this to set the damage for the Diamond Arrow. Base Arrow value is 2.0.").defineInRange("Damage", (double)DiamondArrowEntity.baseDamage, 0.5, 16.0);
        diamondArrowKnockback = SERVER_CONFIG.comment("Adjust this to set the inherent knockback strength of the Diamond Arrow. Base Arrow value is 0.").defineInRange("Knockback", DiamondArrowEntity.baseKnockback, 0, 16);
        diamondArrowPierce = SERVER_CONFIG.comment("Adjust this to set the inherent pierce of the Diamond Arrow. Base Arrow value is 0.").defineInRange("Piercing", (int)DiamondArrowEntity.basePierce, 0, 16);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Displacement");
        displacementArrowRadius = SERVER_CONFIG.comment("Adjust this to set the effect radius for the Displacement Arrow. Set to 0 to disable, but that would be boring (and make the arrow useless).").defineInRange("Radius", DisplacementArrowEntity.effectRadius, 0, 16);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Explosive");
        explosiveArrowStrength = SERVER_CONFIG.comment("Adjust this to set the explosion strength for the Explosive Arrow.").defineInRange("Strength", ExplosiveArrowEntity.explosionStrength, 0.5, 16.0);
        explosiveArrowBreakBlocks = SERVER_CONFIG.comment("If TRUE, explosions break blocks.").define("Break Blocks", ExplosiveArrowEntity.explosionsBreakBlocks);
        explosiveArrowCauseFire = SERVER_CONFIG.comment("If TRUE, explosions cause fires if the arrow is on fire.").define("Cause Fires", ExplosiveArrowEntity.explosionsCauseFire);
        explosiveArrowKnockbackBoost = SERVER_CONFIG.comment("If TRUE, explosion strength is modified by knockback bonuses, such as the Punch Enchantment.").define("Knockback Boost", ExplosiveArrowEntity.knockbackBoost);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Frost");
        frostArrowRadius = SERVER_CONFIG.comment("Adjust this to set the effect radius for the Frost Arrow. Set to 0 to disable, but that would be boring.").defineInRange("Radius", FrostArrowEntity.effectRadius, 0, 16);
        frostArrowPermanentLava = SERVER_CONFIG.comment("If TRUE, Frost Arrows will convert Lava into Obsidian. If FALSE, Glossed Magma.").define("Permanent Lava Freeze", FrostArrowEntity.permanentLava);
        frostArrowPermanentWater = SERVER_CONFIG.comment("If TRUE, Frost Arrows will convert Water into Ice. If FALSE, Frosted Ice.").define("Permanent Water Freeze", FrostArrowEntity.permanentWater);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Glowstone");
        glowstoneArrowRadius = SERVER_CONFIG.comment("Adjust this to set the effect radius for the Glowstone Arrow. Set to 0 to disable, but that would be boring (and make the arrow useless).").defineInRange("Radius", GlowstoneArrowEntity.effectRadius, 0, 16);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Prismarine");
        prismarineArrowDamage = SERVER_CONFIG.comment("Adjust this to set the damage for the Prismarine Arrow. Base Arrow value is 2.0.").defineInRange("Damage", (double)PrismarineArrowEntity.baseDamage, 0.5, 16.0);
        prismarineArrowKnockback = SERVER_CONFIG.comment("Adjust this to set the inherent knockback strength of the Prismarine Arrow. Base Arrow value is 0.").defineInRange("Knockback", PrismarineArrowEntity.baseKnockback, 0, 16);
        prismarineArrowPierce = SERVER_CONFIG.comment("Adjust this to set the inherent pierce of the Prismarine Arrow. Base Arrow value is 0.").defineInRange("Piercing", (int)PrismarineArrowEntity.basePierce, 0, 16);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Quartz");
        quartzArrowDamage = SERVER_CONFIG.comment("Adjust this to set the damage for the Quartz Arrow. Base Arrow value is 2.0.").defineInRange("Damage", (double)QuartzArrowEntity.baseDamage, 0.5, 16.0);
        quartzArrowKnockback = SERVER_CONFIG.comment("Adjust this to set the inherent knockback strength of the Quartz Arrow. Base Arrow value is 0.").defineInRange("Knockback", QuartzArrowEntity.baseKnockback, 0, 16);
        quartzArrowPierce = SERVER_CONFIG.comment("Adjust this to set the inherent pierce of the Quartz Arrow. Base Arrow value is 0.").defineInRange("Piercing", (int)QuartzArrowEntity.basePierce, 0, 16);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Redstone");
        redstoneArrowRadius = SERVER_CONFIG.comment("Adjust this to set the effect radius for the Redstone Arrow. Set to 0 to disable, but that would be boring (and make the arrow useless).").defineInRange("Radius", RedstoneArrowEntity.effectRadius, 0, 16);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Shulker");
        shulkerArrowDuration = SERVER_CONFIG.comment("Adjust this to set the effect duration (Levitation) for the Shulker Arrow. Set to 0 to disable.").defineInRange("Effect Duration", ShulkerArrowEntity.effectDuration, 0, 9600);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Slime");
        slimeArrowBounces = SERVER_CONFIG.comment("Adjust this to set the number of bounces for the Slime Arrow.").defineInRange("Bounces", SlimeArrowEntity.baseBounces, 1, 16);
        slimeArrowKnockback = SERVER_CONFIG.comment("Adjust this to set the inherent knockback strength of the Slime Arrow. Base Arrow value is 0.").defineInRange("Knockback", SlimeArrowEntity.baseKnockback, 0, 16);
        slimeArrowKnockbackBoost = SERVER_CONFIG.comment("If TRUE, bounces are modified by knockback bonuses, such as the Punch Enchantment.").define("Knockback Boost", SlimeArrowEntity.knockbackBoost);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Spore");
        sporeArrowRadius = SERVER_CONFIG.comment("Adjust this to set the effect radius for the Spore Arrow. Set to 0 to disable, but that would be boring (and make the arrow useless).").defineInRange("Radius", SporeArrowEntity.effectRadius, 0, 16);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Verdant");
        verdantArrowRadius = SERVER_CONFIG.comment("Adjust this to set the effect radius for the Verdant Arrow. Set to 0 to disable, but that would be boring (and make the arrow useless).").defineInRange("Radius", VerdantArrowEntity.effectRadius, 0, 16);
        SERVER_CONFIG.pop();
    }

    private static void refreshServerConfig() {
        APConfig.refreshArrowConfig();
    }

    private static void refreshClientConfig() {
    }

    private static void refreshArrowConfig() {
        BlazeArrowEntity.effectDuration = (Integer)blazeArrowDuration.get();
        BlazeArrowEntity.effectRadius = (Integer)blazeArrowRadius.get();
        DiamondArrowEntity.baseDamage = ((Double)diamondArrowDamage.get()).floatValue();
        DiamondArrowEntity.baseKnockback = (Integer)diamondArrowKnockback.get();
        DiamondArrowEntity.basePierce = ((Integer)diamondArrowPierce.get()).byteValue();
        DisplacementArrowEntity.effectRadius = (Integer)displacementArrowRadius.get();
        ExplosiveArrowEntity.explosionStrength = (Double)explosiveArrowStrength.get();
        ExplosiveArrowEntity.explosionsBreakBlocks = (Boolean)explosiveArrowBreakBlocks.get();
        ExplosiveArrowEntity.explosionsCauseFire = (Boolean)explosiveArrowCauseFire.get();
        ExplosiveArrowEntity.knockbackBoost = (Boolean)explosiveArrowKnockbackBoost.get();
        FrostArrowEntity.effectRadius = (Integer)frostArrowRadius.get();
        FrostArrowEntity.permanentLava = (Boolean)frostArrowPermanentLava.get();
        FrostArrowEntity.permanentWater = (Boolean)frostArrowPermanentWater.get();
        GlowstoneArrowEntity.effectRadius = (Integer)glowstoneArrowRadius.get();
        PrismarineArrowEntity.baseDamage = ((Double)prismarineArrowDamage.get()).floatValue();
        PrismarineArrowEntity.baseKnockback = (Integer)prismarineArrowKnockback.get();
        PrismarineArrowEntity.basePierce = ((Integer)prismarineArrowPierce.get()).byteValue();
        QuartzArrowEntity.baseDamage = ((Double)quartzArrowDamage.get()).floatValue();
        QuartzArrowEntity.baseKnockback = (Integer)quartzArrowKnockback.get();
        QuartzArrowEntity.basePierce = ((Integer)quartzArrowPierce.get()).byteValue();
        RedstoneArrowEntity.effectRadius = (Integer)redstoneArrowRadius.get();
        ShulkerArrowEntity.effectDuration = (Integer)shulkerArrowDuration.get();
        SlimeArrowEntity.baseBounces = (Integer)slimeArrowBounces.get();
        SlimeArrowEntity.baseKnockback = (Integer)slimeArrowKnockback.get();
        SlimeArrowEntity.knockbackBoost = (Boolean)slimeArrowKnockbackBoost.get();
        SporeArrowEntity.effectRadius = (Integer)sporeArrowRadius.get();
        VerdantArrowEntity.effectRadius = (Integer)verdantArrowRadius.get();
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.Loading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                APConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                APConfig.refreshServerConfig();
            }
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfig.Reloading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                APConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                APConfig.refreshServerConfig();
            }
        }
    }

    static {
        CLIENT_CONFIG = new ForgeConfigSpec.Builder();
    }
}

