/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.block.growable;

import enemeez.simplefarming.init.ModBlocks;
import enemeez.simplefarming.init.ModItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FruitLeavesBlock
extends LeavesBlock
implements IGrowable {
    private String name;
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;

    public FruitLeavesBlock(Block.Properties properties, String name) {
        super(properties);
        this.name = name;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)field_208494_a, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)field_208495_b, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        switch (this.name) {
            case "apple": {
                return new ItemStack((IItemProvider)Items.field_151034_e);
            }
            case "apricot": {
                return new ItemStack((IItemProvider)ModItems.apricot);
            }
            case "banana": {
                return new ItemStack((IItemProvider)ModItems.banana);
            }
            case "cherries": {
                return new ItemStack((IItemProvider)ModItems.cherries);
            }
            case "orange": {
                return new ItemStack((IItemProvider)ModItems.orange);
            }
            case "mango": {
                return new ItemStack((IItemProvider)ModItems.mango);
            }
            case "pear": {
                return new ItemStack((IItemProvider)ModItems.pear);
            }
            case "plum": {
                return new ItemStack((IItemProvider)ModItems.plum);
            }
        }
        return new ItemStack((IItemProvider)ModItems.olives);
    }

    public ItemStack getSapling(IBlockReader worldIn, BlockPos pos, BlockState state) {
        switch (this.name) {
            case "apple": {
                return new ItemStack((IItemProvider)ModItems.apple_sapling);
            }
            case "apricot": {
                return new ItemStack((IItemProvider)ModItems.apricot_sapling);
            }
            case "banana": {
                return new ItemStack((IItemProvider)ModItems.banana_sapling);
            }
            case "cherries": {
                return new ItemStack((IItemProvider)ModItems.cherry_sapling);
            }
            case "orange": {
                return new ItemStack((IItemProvider)ModItems.orange_sapling);
            }
            case "mango": {
                return new ItemStack((IItemProvider)ModItems.mango_sapling);
            }
            case "pear": {
                return new ItemStack((IItemProvider)ModItems.pear_sapling);
            }
            case "plum": {
                return new ItemStack((IItemProvider)ModItems.plum_sapling);
            }
        }
        return new ItemStack((IItemProvider)ModItems.olive_sapling);
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)field_208494_a) == 7 && (Boolean)state.func_177229_b((IProperty)field_208495_b) == false || !this.isMaxAge(state);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((IProperty)field_208495_b)).booleanValue() && (Integer)state.func_177229_b((IProperty)field_208494_a) == 7) {
            FruitLeavesBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_217377_a(pos, false);
        } else {
            super.func_225534_a_(state, worldIn, pos, random);
            int i = (Integer)state.func_177229_b((IProperty)AGE);
            if (i < 7 && random.nextInt(5) == 0 && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            }
        }
    }

    private static BlockState updateDistance(BlockState state, IWorld worldIn, BlockPos pos) {
        int i = 7;
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (Direction direction : Direction.values()) {
                blockpos$pooledmutable.func_189533_g((Vec3i)pos).func_189536_c(direction);
                i = Math.min(i, FruitLeavesBlock.getDistance(worldIn.func_180495_p((BlockPos)blockpos$pooledmutable)) + 1);
                if (i != 1) continue;
                break;
            }
        }
        return (BlockState)state.func_206870_a((IProperty)field_208494_a, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(BlockState neighbor) {
        if (ModBlocks.fruit_log == neighbor.func_177230_c()) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof FruitLeavesBlock ? (Integer)neighbor.func_177229_b((IProperty)field_208494_a) : 7;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return FruitLeavesBlock.updateDistance((BlockState)this.func_176223_P().func_206870_a((IProperty)field_208495_b, (Comparable)Boolean.valueOf(true)), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_208494_a, field_208495_b, AGE});
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge();
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state);
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = Math.min(7, (Integer)state.func_177229_b((IProperty)AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

