/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.init;

import enemeez.simplefarming.SimpleFarming;
import enemeez.simplefarming.config.EnableConfig;
import enemeez.simplefarming.world.gen.BerryBushFeature;
import enemeez.simplefarming.world.gen.CactusCropFeature;
import enemeez.simplefarming.world.gen.WildCropFeature;
import enemeez.simplefarming.world.gen.WildPlantFeature;
import enemeez.simplefarming.world.gen.feature.tree.FruitTreeFeature;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModWorldGen {
    public static Feature<NoFeatureConfig> fruit_tree;
    public static Feature<NoFeatureConfig> berry_bush;
    public static Feature<NoFeatureConfig> cactus_crop;
    public static Feature<NoFeatureConfig> wild_crop;
    public static Feature<NoFeatureConfig> wild_plant;

    public static void registerAll(RegistryEvent.Register<Feature<?>> event) {
        if (!event.getName().equals((Object)ForgeRegistries.FEATURES.getRegistryName())) {
            return;
        }
        IForgeRegistry r = event.getRegistry();
        if (((Boolean)EnableConfig.tree_validate.get()).booleanValue()) {
            fruit_tree = ModWorldGen.register(r, new FruitTreeFeature(NoFeatureConfig::func_214639_a), "fruit_tree");
        }
        if (((Boolean)EnableConfig.bush_validate.get()).booleanValue()) {
            berry_bush = ModWorldGen.register(r, new BerryBushFeature(NoFeatureConfig::func_214639_a), "berry_bush");
        }
        if (((Boolean)EnableConfig.cactus_validate.get()).booleanValue()) {
            cactus_crop = ModWorldGen.register(r, new CactusCropFeature(NoFeatureConfig::func_214639_a), "cactus_crop");
        }
        if (((Boolean)EnableConfig.wild_crop_validate.get()).booleanValue()) {
            wild_crop = ModWorldGen.register(r, new WildCropFeature(NoFeatureConfig::func_214639_a), "wild_crop");
        }
        if (((Boolean)EnableConfig.wild_plant_validate.get()).booleanValue()) {
            wild_plant = ModWorldGen.register(r, new WildPlantFeature(NoFeatureConfig::func_214639_a), "wild_plant");
        }
    }

    private static <V extends R, R extends IForgeRegistryEntry<R>> V register(IForgeRegistry<R> registry, V value, String name) {
        ResourceLocation id = SimpleFarming.getId(name);
        value.setRegistryName(id);
        registry.register(value);
        return value;
    }
}

