/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.compat.jei.ConversionRecipe;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.contraptions.components.crusher.CrushingRecipe;
import com.simibubi.create.content.contraptions.components.fan.SplashingRecipe;
import com.simibubi.create.content.contraptions.components.millstone.MillingRecipe;
import com.simibubi.create.content.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.components.saw.CuttingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeSerializer;
import com.simibubi.create.content.curiosities.tools.SandPaperPolishingRecipe;
import com.simibubi.create.content.curiosities.zapper.blockzapper.BlockzapperUpgradeRecipe;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum AllRecipeTypes {
    BLOCKZAPPER_UPGRADE(BlockzapperUpgradeRecipe.Serializer::new, (IRecipeType<? extends IRecipe<? extends IInventory>>)IRecipeType.field_222149_a),
    MECHANICAL_CRAFTING(MechanicalCraftingRecipe.Serializer::new),
    CRUSHING(AllRecipeTypes.processingSerializer(CrushingRecipe::new)),
    MILLING(AllRecipeTypes.processingSerializer(MillingRecipe::new)),
    SPLASHING(AllRecipeTypes.processingSerializer(SplashingRecipe::new)),
    PRESSING(AllRecipeTypes.processingSerializer(PressingRecipe::new)),
    CUTTING(AllRecipeTypes.processingSerializer(CuttingRecipe::new)),
    MIXING(AllRecipeTypes.processingSerializer(MixingRecipe::new)),
    SANDPAPER_POLISHING(AllRecipeTypes.processingSerializer(SandPaperPolishingRecipe::new)),
    CONVERSION(AllRecipeTypes.processingSerializer(ConversionRecipe::new));

    public IRecipeSerializer<?> serializer;
    public Supplier<IRecipeSerializer<?>> supplier;
    public IRecipeType<? extends IRecipe<? extends IInventory>> type;

    public <T extends IRecipeType<?>> T getType() {
        return (T)this.type;
    }

    private AllRecipeTypes(Supplier<IRecipeSerializer<?>> supplier) {
        this(supplier, null);
    }

    private AllRecipeTypes(Supplier<IRecipeSerializer<?>> supplier, IRecipeType<? extends IRecipe<? extends IInventory>> existingType) {
        this.supplier = supplier;
        this.type = existingType;
    }

    public static void register(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        ShapedRecipe.setCraftingSize((int)9, (int)9);
        for (AllRecipeTypes r : AllRecipeTypes.values()) {
            if (r.type == null) {
                r.type = AllRecipeTypes.customType(Lang.asId(r.name()));
            }
            r.serializer = r.supplier.get();
            ResourceLocation location = new ResourceLocation("create", Lang.asId(r.name()));
            event.getRegistry().register((IForgeRegistryEntry)r.serializer.setRegistryName(location));
        }
    }

    private static <T extends IRecipe<?>> IRecipeType<T> customType(final String id) {
        return (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation("create", id), (Object)new IRecipeType<T>(){

            public String toString() {
                return "create:" + id;
            }
        });
    }

    private static Supplier<IRecipeSerializer<?>> processingSerializer(ProcessingRecipeSerializer.IRecipeFactory<? extends ProcessingRecipe<?>> factory) {
        return () -> new ProcessingRecipeSerializer(factory);
    }
}

