/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.content.palettes.PaletteBlockPatterns;
import com.simibubi.create.content.palettes.PaletteStoneVariants;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.block.render.SpriteShifter;
import com.simibubi.create.foundation.utility.Lang;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.WoodType;

public class AllSpriteShifts {
    static final Map<WoodType, CTSpriteShiftEntry> WOODEN_WINDOWS = new IdentityHashMap<WoodType, CTSpriteShiftEntry>();
    static final Map<PaletteStoneVariants, Map<PaletteBlockPatterns.CTs, CTSpriteShiftEntry>> PALETTE_VARIANT_PATTERNS = new IdentityHashMap<PaletteStoneVariants, Map<PaletteBlockPatterns.CTs, CTSpriteShiftEntry>>();
    public static final CTSpriteShiftEntry FRAMED_GLASS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "palettes/framed_glass", "palettes/framed_glass");
    public static final CTSpriteShiftEntry HORIZONTAL_FRAMED_GLASS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.HORIZONTAL, "palettes/framed_glass", "palettes/horizontal_framed_glass");
    public static final CTSpriteShiftEntry VERTICAL_FRAMED_GLASS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.VERTICAL, "palettes/framed_glass", "palettes/vertical_framed_glass");
    public static final CTSpriteShiftEntry ORNATE_IRON_WINDOW = AllSpriteShifts.vertical("palettes/ornate_iron_window");
    public static final CTSpriteShiftEntry CRAFTER_FRONT = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "crafter_top", "brass_casing");
    public static final CTSpriteShiftEntry CRAFTER_SIDE = CTSpriteShifter.getCT(CTSpriteShifter.CTType.VERTICAL, "crafter_side");
    public static final CTSpriteShiftEntry CRAFTER_OTHERSIDE = CTSpriteShifter.getCT(CTSpriteShifter.CTType.HORIZONTAL, "crafter_side");
    public static final CTSpriteShiftEntry ANDESITE_CASING = AllSpriteShifts.omni("andesite_casing");
    public static final CTSpriteShiftEntry BRASS_CASING = AllSpriteShifts.omni("brass_casing");
    public static final CTSpriteShiftEntry COPPER_CASING = AllSpriteShifts.omni("copper_casing");
    public static final CTSpriteShiftEntry CHASSIS = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "linear_chassis_end");
    public static final CTSpriteShiftEntry CHASSIS_STICKY = CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "linear_chassis_end_sticky");
    public static final SpriteShiftEntry BELT = SpriteShifter.get("block/belt", "block/belt_animated");
    public static final SpriteShiftEntry CRAFTER_THINGIES = SpriteShifter.get("block/crafter_thingies", "block/crafter_thingies");

    public static CTSpriteShiftEntry getWoodenWindow(WoodType woodType) {
        return WOODEN_WINDOWS.get(woodType);
    }

    public static CTSpriteShiftEntry getVariantPattern(PaletteStoneVariants variant, PaletteBlockPatterns.CTs texture) {
        return PALETTE_VARIANT_PATTERNS.get((Object)variant).get((Object)texture);
    }

    private static void populateMaps() {
        WoodType.func_227046_a_().forEach(woodType -> WOODEN_WINDOWS.put((WoodType)woodType, AllSpriteShifts.vertical("palettes/" + woodType.func_227048_b_() + "_window")));
        for (PaletteStoneVariants paletteStoneVariants : PaletteStoneVariants.values()) {
            String variantName = Lang.asId(paletteStoneVariants.name());
            IdentityHashMap<PaletteBlockPatterns.CTs, CTSpriteShiftEntry> map = new IdentityHashMap<PaletteBlockPatterns.CTs, CTSpriteShiftEntry>();
            PALETTE_VARIANT_PATTERNS.put(paletteStoneVariants, map);
            for (PaletteBlockPatterns.CTs texture : PaletteBlockPatterns.CTs.values()) {
                String textureName = Lang.asId(texture.name());
                String target = "palettes/" + variantName + "/" + textureName;
                map.put(texture, CTSpriteShifter.getCT(texture.type, target));
            }
        }
    }

    static CTSpriteShiftEntry omni(String name) {
        return CTSpriteShifter.getCT(CTSpriteShifter.CTType.OMNIDIRECTIONAL, name);
    }

    static CTSpriteShiftEntry vertical(String name) {
        return CTSpriteShifter.getCT(CTSpriteShifter.CTType.VERTICAL, name);
    }

    static CTSpriteShiftEntry horizontal(String name) {
        return CTSpriteShifter.getCT(CTSpriteShifter.CTType.HORIZONTAL, name);
    }

    static {
        AllSpriteShifts.populateMaps();
    }
}

