/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.mojang.brigadier.CommandDispatcher;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.command.CreateCommand;
import net.minecraft.command.CommandSource;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

@Mod.EventBusSubscriber
public class CommonEvents {
    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Create.tick();
    }

    @SubscribeEvent
    public static void onClose(FMLServerStoppingEvent event) {
        Create.shutdown();
    }

    @SubscribeEvent
    public static void serverStarting(FMLServerStartingEvent event) {
        new CreateCommand((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public static void onLoadWorld(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        Create.redstoneLinkNetworkHandler.onLoadWorld(world);
        Create.torquePropagator.onLoadWorld(world);
        if (event.getWorld().func_201670_d()) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> CreateClient.bufferCache::invalidate);
        }
    }

    @SubscribeEvent
    public static void onUnloadWorld(WorldEvent.Unload event) {
        IWorld world = event.getWorld();
        Create.redstoneLinkNetworkHandler.onUnloadWorld(world);
        Create.torquePropagator.onUnloadWorld(world);
    }
}

