/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllContainerTypes;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.CreateItemGroup;
import com.simibubi.create.content.contraptions.TorquePropagator;
import com.simibubi.create.content.logistics.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.palettes.AllPaletteBlocks;
import com.simibubi.create.content.palettes.PalettesItemGroup;
import com.simibubi.create.content.schematics.ServerSchematicLoader;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.command.ServerLagger;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.LangMerger;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.worldgen.AllWorldFeatures;
import com.simibubi.create.repack.registrate.util.NonNullLazyValue;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="create")
public class Create {
    public static final String ID = "create";
    public static final String NAME = "Create";
    public static final String VERSION = "0.2.4e";
    public static Logger logger = LogManager.getLogger();
    public static ItemGroup baseCreativeTab = new CreateItemGroup();
    public static ItemGroup palettesCreativeTab = new PalettesItemGroup();
    public static ServerSchematicLoader schematicReceiver;
    public static RedstoneLinkNetworkHandler redstoneLinkNetworkHandler;
    public static TorquePropagator torquePropagator;
    public static ServerLagger lagger;
    private static final NonNullLazyValue<CreateRegistrate> registrate;

    public Create() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        AllBlocks.register();
        AllItems.register();
        AllPaletteBlocks.register();
        AllEntityTypes.register();
        AllTileEntities.register();
        modEventBus.addListener(Create::init);
        modEventBus.addGenericListener(IRecipeSerializer.class, AllRecipeTypes::register);
        modEventBus.addGenericListener(ContainerType.class, AllContainerTypes::register);
        modEventBus.addGenericListener(ParticleType.class, AllParticleTypes::register);
        modEventBus.addGenericListener(SoundEvent.class, AllSoundEvents::register);
        modEventBus.addListener(AllConfigs::onLoad);
        modEventBus.addListener(AllConfigs::onReload);
        modEventBus.addListener(EventPriority.LOWEST, this::gatherData);
        CreateClient.addClientListeners(modEventBus);
        AllConfigs.register();
    }

    public static void init(FMLCommonSetupEvent event) {
        schematicReceiver = new ServerSchematicLoader();
        redstoneLinkNetworkHandler = new RedstoneLinkNetworkHandler();
        torquePropagator = new TorquePropagator();
        lagger = new ServerLagger();
        AllPackets.registerPackets();
        AllTriggers.register();
        AllWorldFeatures.reload();
    }

    public static void tick() {
        if (schematicReceiver == null) {
            schematicReceiver = new ServerSchematicLoader();
        }
        schematicReceiver.tick();
        lagger.tick();
    }

    public static void shutdown() {
        schematicReceiver.shutdown();
    }

    public static CreateRegistrate registrate() {
        return registrate.get();
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(ID, path);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.func_200390_a((IDataProvider)new AllAdvancements(gen));
        gen.func_200390_a((IDataProvider)new LangMerger(gen));
    }

    static {
        registrate = CreateRegistrate.lazy(ID);
    }
}

