/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllColorHandlers;
import com.simibubi.create.AllContainerTypes;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.ChassisRangeDisplay;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionRenderer;
import com.simibubi.create.content.contraptions.relays.belt.item.BeltConnectorHandler;
import com.simibubi.create.content.curiosities.tools.ExtendoGripRenderHandler;
import com.simibubi.create.content.curiosities.zapper.ZapperRenderHandler;
import com.simibubi.create.content.curiosities.zapper.blockzapper.BlockzapperRenderHandler;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.WorldshaperRenderHandler;
import com.simibubi.create.content.schematics.ClientSchematicLoader;
import com.simibubi.create.content.schematics.client.SchematicAndQuillHandler;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.foundation.ResourceReloadHandler;
import com.simibubi.create.foundation.block.render.CustomBlockModels;
import com.simibubi.create.foundation.block.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.block.render.SpriteShifter;
import com.simibubi.create.foundation.item.CustomItemModels;
import com.simibubi.create.foundation.item.CustomRenderedItems;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueRenderer;
import com.simibubi.create.foundation.utility.SuperByteBufferCache;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class CreateClient {
    public static ClientSchematicLoader schematicSender;
    public static SchematicHandler schematicHandler;
    public static SchematicAndQuillHandler schematicAndQuillHandler;
    public static SuperByteBufferCache bufferCache;
    public static Outliner outliner;
    private static CustomBlockModels customBlockModels;
    private static CustomItemModels customItemModels;
    private static CustomRenderedItems customRenderedItems;
    private static AllColorHandlers colorHandlers;

    public static void addClientListeners(IEventBus modEventBus) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(CreateClient::clientInit);
            modEventBus.addListener(CreateClient::onModelBake);
            modEventBus.addListener(CreateClient::onModelRegistry);
            modEventBus.addListener(CreateClient::onTextureStitch);
            modEventBus.addListener(AllParticleTypes::registerFactories);
        });
    }

    public static void clientInit(FMLClientSetupEvent event) {
        schematicSender = new ClientSchematicLoader();
        schematicHandler = new SchematicHandler();
        schematicAndQuillHandler = new SchematicAndQuillHandler();
        outliner = new Outliner();
        bufferCache = new SuperByteBufferCache();
        bufferCache.registerCompartment(KineticTileEntityRenderer.KINETIC_TILE);
        bufferCache.registerCompartment(ContraptionRenderer.CONTRAPTION, 20L);
        AllKeys.register();
        AllContainerTypes.registerScreenFactories();
        AllTileEntities.registerRenderers();
        AllEntityTypes.registerRenderers();
        CreateClient.getColorHandler().init();
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)new ResourceReloadHandler());
        }
    }

    public static void gameTick() {
        schematicSender.tick();
        schematicAndQuillHandler.tick();
        schematicHandler.tick();
        BeltConnectorHandler.tick();
        FilteringRenderer.tick();
        LinkRenderer.tick();
        ScrollValueRenderer.tick();
        ChassisRangeDisplay.tick();
        EdgeInteractionRenderer.tick();
        WorldshaperRenderHandler.tick();
        BlockzapperRenderHandler.tick();
        KineticDebugger.tick();
        ZapperRenderHandler.tick();
        ExtendoGripRenderHandler.tick();
        outliner.tickOutlines();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            return;
        }
        SpriteShifter.getAllTargetSprites().forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        AllBlockPartials.onModelBake(event);
        CreateClient.getCustomBlockModels().foreach((block, modelFunc) -> CreateClient.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, CreateClient.getAllBlockStateModelLocations(block), modelFunc));
        CreateClient.getCustomItemModels().foreach((item, modelFunc) -> CreateClient.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, CreateClient.getItemModelLocation(item), modelFunc));
        CreateClient.getCustomRenderedItems().foreach((item, modelFunc) -> CreateClient.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, CreateClient.getItemModelLocation(item), (IBakedModel m) -> ((CustomRenderedItemModel)modelFunc.apply(m)).loadPartials(event)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistry(ModelRegistryEvent event) {
        AllBlockPartials.onModelRegistry(event);
        CreateClient.getCustomRenderedItems().foreach((item, modelFunc) -> ((CustomRenderedItemModel)modelFunc.apply(null)).getModelLocations().forEach(ModelLoader::addSpecialModel));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static ModelResourceLocation getItemModelLocation(Item item) {
        return new ModelResourceLocation(item.getRegistryName(), "inventory");
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static List<ModelResourceLocation> getAllBlockStateModelLocations(Block block) {
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
        block.func_176194_O().func_177619_a().forEach(state -> models.add(CreateClient.getBlockModelLocation(block, BlockModelShapes.func_209552_a((Map)state.func_206871_b()))));
        return models;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static ModelResourceLocation getBlockModelLocation(Block block, String suffix) {
        return new ModelResourceLocation(block.getRegistryName(), suffix);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static <T extends IBakedModel> void swapModels(Map<ResourceLocation, IBakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<IBakedModel, T> factory) {
        locations.forEach(location -> CreateClient.swapModels(modelRegistry, location, factory));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static <T extends IBakedModel> void swapModels(Map<ResourceLocation, IBakedModel> modelRegistry, ModelResourceLocation location, Function<IBakedModel, T> factory) {
        modelRegistry.put((ResourceLocation)location, (IBakedModel)factory.apply(modelRegistry.get(location)));
    }

    public static CustomItemModels getCustomItemModels() {
        if (customItemModels == null) {
            customItemModels = new CustomItemModels();
        }
        return customItemModels;
    }

    public static CustomRenderedItems getCustomRenderedItems() {
        if (customRenderedItems == null) {
            customRenderedItems = new CustomRenderedItems();
        }
        return customRenderedItems;
    }

    public static CustomBlockModels getCustomBlockModels() {
        if (customBlockModels == null) {
            customBlockModels = new CustomBlockModels();
        }
        return customBlockModels;
    }

    public static AllColorHandlers getColorHandler() {
        if (colorHandlers == null) {
            colorHandlers = new AllColorHandlers();
        }
        return colorHandlers;
    }
}

