/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class DirectionalAxisKineticBlock
extends DirectionalKineticBlock {
    public static final BooleanProperty AXIS_ALONG_FIRST_COORDINATE = BooleanProperty.func_177716_a((String)"axis_along_first");

    public DirectionalAxisKineticBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AXIS_ALONG_FIRST_COORDINATE});
        super.func_206840_a(builder);
    }

    protected Direction getFacingForPlacement(BlockItemUseContext context) {
        Direction facing = context.func_196010_d().func_176734_d();
        if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            facing = facing.func_176734_d();
        }
        return facing;
    }

    protected boolean getAxisAlignmentForPlacement(BlockItemUseContext context) {
        return context.func_195992_f().func_176740_k() == Direction.Axis.X;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = this.getFacingForPlacement(context);
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        boolean alongFirst = false;
        if (facing.func_176740_k().func_176722_c()) {
            boolean shaftBelow;
            alongFirst = facing.func_176740_k() == Direction.Axis.Z;
            Block blockAbove = world.func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c();
            boolean shaftAbove = blockAbove instanceof IRotate && ((IRotate)blockAbove).hasShaftTowards((IWorldReader)world, pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()), Direction.DOWN);
            Block blockBelow = world.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c();
            boolean bl = shaftBelow = blockBelow instanceof IRotate && ((IRotate)blockBelow).hasShaftTowards((IWorldReader)world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), Direction.UP);
            if (shaftAbove || shaftBelow) {
                boolean bl2 = alongFirst = facing.func_176740_k() == Direction.Axis.X;
            }
        }
        if (facing.func_176740_k().func_200128_b()) {
            alongFirst = this.getAxisAlignmentForPlacement(context);
            Direction prefferedSide = null;
            for (Direction side : Direction.values()) {
                BlockState blockState;
                if (side.func_176740_k().func_200128_b() || !((blockState = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(side))).func_177230_c() instanceof IRotate) || !((IRotate)blockState.func_177230_c()).hasShaftTowards((IWorldReader)context.func_195991_k(), context.func_195995_a().func_177972_a(side), blockState, side.func_176734_d())) continue;
                if (prefferedSide != null && prefferedSide.func_176740_k() != side.func_176740_k()) {
                    prefferedSide = null;
                    break;
                }
                prefferedSide = side;
            }
            if (prefferedSide != null) {
                alongFirst = prefferedSide.func_176740_k() == Direction.Axis.X;
            }
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing)).func_206870_a((IProperty)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(alongFirst));
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        Direction.Axis pistonAxis = ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k();
        boolean alongFirst = (Boolean)state.func_177229_b((IProperty)AXIS_ALONG_FIRST_COORDINATE);
        if (pistonAxis == Direction.Axis.X) {
            return alongFirst ? Direction.Axis.Y : Direction.Axis.Z;
        }
        if (pistonAxis == Direction.Axis.Y) {
            return alongFirst ? Direction.Axis.X : Direction.Axis.Z;
        }
        if (pistonAxis == Direction.Axis.Z) {
            return alongFirst ? Direction.Axis.X : Direction.Axis.Y;
        }
        throw new IllegalStateException("Unknown axis??");
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        if (rot.ordinal() % 2 == 1) {
            state = (BlockState)state.func_177231_a((IProperty)AXIS_ALONG_FIRST_COORDINATE);
        }
        return super.func_185499_a(state, rot);
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face.func_176740_k() == this.getRotationAxis(state);
    }
}

