/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.particle.RotationIndicatorParticleData;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class KineticEffectHandler {
    int overStressedTime;
    float overStressedEffect;
    int particleSpawnCountdown;
    KineticTileEntity kte;

    public KineticEffectHandler(KineticTileEntity kte) {
        this.kte = kte;
    }

    public void tick() {
        World world = this.kte.func_145831_w();
        if (world.field_72995_K) {
            if (this.overStressedTime > 0 && --this.overStressedTime == 0) {
                if (this.kte.overStressed) {
                    this.overStressedEffect = 1.0f;
                    this.spawnEffect((IParticleData)ParticleTypes.field_197601_L, 0.2f, 5);
                } else {
                    this.overStressedEffect = -1.0f;
                    this.spawnEffect((IParticleData)ParticleTypes.field_197613_f, 0.075f, 2);
                }
            }
            if (this.overStressedEffect != 0.0f) {
                this.overStressedEffect -= this.overStressedEffect * 0.1f;
                if (Math.abs(this.overStressedEffect) < 0.0078125f) {
                    this.overStressedEffect = 0.0f;
                }
            }
        } else if (this.particleSpawnCountdown > 0 && --this.particleSpawnCountdown == 0) {
            this.spawnRotationIndicators();
        }
    }

    public void queueRotationIndicators() {
        this.particleSpawnCountdown = 2;
    }

    public void spawnEffect(IParticleData particle, float maxMotion, int amount) {
        World world = this.kte.func_145831_w();
        if (world == null) {
            return;
        }
        if (!world.field_72995_K) {
            return;
        }
        Random r = world.field_73012_v;
        for (int i = 0; i < amount; ++i) {
            Vec3d motion = VecHelper.offsetRandomly(Vec3d.field_186680_a, r, maxMotion);
            Vec3d position = VecHelper.getCenterOf((Vec3i)this.kte.func_174877_v());
            world.func_195594_a(particle, position.field_72450_a, position.field_72448_b, position.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        }
    }

    public void spawnRotationIndicators() {
        float speed = this.kte.getSpeed();
        if (speed == 0.0f) {
            return;
        }
        BlockState state = this.kte.func_195044_w();
        Block block = state.func_177230_c();
        if (!(block instanceof KineticBlock)) {
            return;
        }
        KineticBlock kb = (KineticBlock)block;
        float radius1 = kb.getParticleInitialRadius();
        float radius2 = kb.getParticleTargetRadius();
        Direction.Axis axis = kb.getRotationAxis(state);
        BlockPos pos = this.kte.func_174877_v();
        World world = this.kte.func_145831_w();
        if (axis == null) {
            return;
        }
        if (world == null) {
            return;
        }
        char axisChar = axis.name().charAt(0);
        Vec3d vec = VecHelper.getCenterOf((Vec3i)pos);
        IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of(speed);
        int color = speedLevel.getColor();
        int particleSpeed = speedLevel.getParticleSpeed();
        particleSpeed = (int)((float)particleSpeed * Math.signum(speed));
        if (world instanceof ServerWorld) {
            AllTriggers.triggerForNearbyPlayers(AllTriggers.ROTATION, world, pos, 5);
            RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, radius1, radius2, 10, axisChar);
            ((ServerWorld)world).func_195598_a((IParticleData)particleData, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 20, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public void triggerOverStressedEffect() {
        this.overStressedTime = this.overStressedTime == 0 ? 2 : 0;
    }
}

