/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.actors.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.TreeCutter;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SawMovementBehaviour
extends BlockBreakingMovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return SawBlock.isHorizontal(context.state);
    }

    @Override
    public Vec3d getActiveAreaOffset(MovementContext context) {
        return new Vec3d(((Direction)context.state.func_177229_b((IProperty)SawBlock.FACING)).func_176730_m()).func_186678_a((double)0.65f);
    }

    @Override
    public boolean canBreak(World world, BlockPos breakingPos, BlockState state) {
        return super.canBreak(world, breakingPos, state) && SawTileEntity.isSawable(state);
    }

    @Override
    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        if (brokenState.func_203425_a(BlockTags.field_206952_E)) {
            return;
        }
        TreeCutter.Tree tree = TreeCutter.cutTree((IBlockReader)context.world, pos);
        if (tree != null) {
            for (BlockPos log : tree.logs) {
                BlockHelper.destroyBlock(context.world, log, 0.5f, stack -> this.dropItemFromCutTree(context, log, (ItemStack)stack));
            }
            for (BlockPos leaf : tree.leaves) {
                BlockHelper.destroyBlock(context.world, leaf, 0.125f, stack -> this.dropItemFromCutTree(context, leaf, (ItemStack)stack));
            }
        }
    }

    public void dropItemFromCutTree(MovementContext context, BlockPos pos, ItemStack stack) {
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)context.contraption.inventory, (ItemStack)stack, (boolean)false);
        if (remainder.func_190926_b()) {
            return;
        }
        World world = context.world;
        Vec3d dropPos = VecHelper.getCenterOf((Vec3i)pos);
        float distance = (float)dropPos.func_72438_d(context.position);
        ItemEntity entity = new ItemEntity(world, dropPos.field_72450_a, dropPos.field_72448_b, dropPos.field_72449_c, remainder);
        entity.func_213317_d(context.relativeMotion.func_186678_a((double)(distance / 20.0f)));
        world.func_217376_c((Entity)entity);
    }

    @Override
    protected DamageSource getDamageSource() {
        return SawBlock.damageSourceSaw;
    }
}

