/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class FlywheelBlock
extends HorizontalKineticBlock {
    public static EnumProperty<ConnectionState> CONNECTION = EnumProperty.func_177709_a((String)"connection", ConnectionState.class);

    public FlywheelBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(CONNECTION, (Comparable)((Object)ConnectionState.NONE)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new IProperty[]{CONNECTION}));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.FLYWHEEL.create();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction preferred = this.getPreferredHorizontalFacing(context);
        if (preferred != null) {
            return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_FACING, (Comparable)preferred.func_176734_d());
        }
        return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_FACING, (Comparable)context.func_195992_f());
    }

    @Override
    protected boolean hasStaticPart() {
        return true;
    }

    public static boolean isConnected(BlockState state) {
        return FlywheelBlock.getConnection(state) != null;
    }

    public static Direction getConnection(BlockState state) {
        Direction facing = (Direction)state.func_177229_b(HORIZONTAL_FACING);
        ConnectionState connection = (ConnectionState)((Object)state.func_177229_b(CONNECTION));
        if (connection == ConnectionState.LEFT) {
            return facing.func_176735_f();
        }
        if (connection == ConnectionState.RIGHT) {
            return facing.func_176746_e();
        }
        return null;
    }

    public static void setConnection(World world, BlockPos pos, BlockState state, Direction direction) {
        Direction facing = (Direction)state.func_177229_b(HORIZONTAL_FACING);
        ConnectionState connection = ConnectionState.NONE;
        if (direction == facing.func_176746_e()) {
            connection = ConnectionState.RIGHT;
        }
        if (direction == facing.func_176735_f()) {
            connection = ConnectionState.LEFT;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a(CONNECTION, (Comparable)((Object)connection)), 18);
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176734_d();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k();
    }

    public static enum ConnectionState implements IStringSerializable
    {
        NONE,
        LEFT,
        RIGHT;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

