/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.millstone;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.millstone.MillingRecipe;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MillstoneTileEntity
extends KineticTileEntity {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(9);
    public int timer;
    private MillingRecipe lastRecipe;

    public MillstoneTileEntity(TileEntityType<? extends MillstoneTileEntity> type) {
        super(type);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).func_190916_E() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.field_145850_b.field_72995_K) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).func_190926_b()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.field_145850_b)) {
            Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(AllRecipeTypes.MILLING.getType(), (IInventory)inventoryIn, this.field_145850_b);
            if (!recipe.isPresent()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = (MillingRecipe)recipe.get();
                this.timer = this.lastRecipe.getProcessingDuration();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.getProcessingDuration();
        this.sendData();
    }

    private void process() {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.field_145850_b)) {
            Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(AllRecipeTypes.MILLING.getType(), (IInventory)inventoryIn, this.field_145850_b);
            if (!recipe.isPresent()) {
                return;
            }
            this.lastRecipe = (MillingRecipe)recipe.get();
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.func_190918_g(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        this.lastRecipe.rollResults().forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)stack, (boolean)false));
        this.sendData();
        this.func_70296_d();
    }

    public void spawnParticles() {
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.func_190926_b()) {
            return;
        }
        ItemParticleData data = new ItemParticleData(ParticleTypes.field_197591_B, stackInSlot);
        float angle = this.field_145850_b.field_73012_v.nextFloat() * 360.0f;
        Vec3d offset = new Vec3d(0.0, 0.0, 0.5);
        offset = VecHelper.rotate(offset, angle, Direction.Axis.Y);
        Vec3d target = VecHelper.rotate(offset, this.getSpeed() > 0.0f ? 25.0 : -25.0, Direction.Axis.Y);
        Vec3d center = offset.func_178787_e(VecHelper.getCenterOf((Vec3i)this.field_174879_c));
        target = VecHelper.offsetRandomly(target.func_178788_d(offset), this.field_145850_b.field_73012_v, 0.0078125f);
        this.field_145850_b.func_195594_a((IParticleData)data, center.field_72450_a, center.field_72448_b, center.field_72449_c, target.field_72450_a, target.field_72448_b, target.field_72449_c);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("Timer", this.timer);
        compound.func_218657_a("InputInventory", (INBT)this.inputInv.serializeNBT());
        compound.func_218657_a("OutputInventory", (INBT)this.outputInv.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.timer = compound.func_74762_e("Timer");
        this.inputInv.deserializeNBT(compound.func_74775_l("InputInventory"));
        this.outputInv.deserializeNBT(compound.func_74775_l("OutputInventory"));
        super.func_145839_a(compound);
    }

    public int getProcessingSpeed() {
        return MathHelper.func_76125_a((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> new MillstoneInventoryHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    private boolean canProcess(ItemStack stack) {
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)tester);
        if (this.lastRecipe != null && this.lastRecipe.matches(inventoryIn, this.field_145850_b)) {
            return true;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(AllRecipeTypes.MILLING.getType(), (IInventory)inventoryIn, this.field_145850_b).isPresent();
    }

    private class MillstoneInventoryHandler
    extends CombinedInvWrapper {
        public MillstoneInventoryHandler() {
            super(new IItemHandlerModifiable[]{MillstoneTileEntity.this.inputInv, MillstoneTileEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (MillstoneTileEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return MillstoneTileEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (MillstoneTileEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (MillstoneTileEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

