/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.motor;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.motor.CreativeMotorBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;

public class CreativeMotorTileEntity
extends GeneratingKineticTileEntity {
    public static final int DEFAULT_SPEED = 16;
    protected ScrollValueBehaviour generatedSpeed;

    public CreativeMotorTileEntity(TileEntityType<? extends CreativeMotorTileEntity> type) {
        super(type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        Integer max = (Integer)AllConfigs.SERVER.kinetics.maxMotorSpeed.get();
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> motor.func_177229_b((IProperty)CreativeMotorBlock.FACING) == side.func_176734_d());
        this.generatedSpeed = new ScrollValueBehaviour(Lang.translate("generic.speed", new Object[0]), this, slot);
        this.generatedSpeed.between(-max.intValue(), max);
        this.generatedSpeed.value = 16;
        this.generatedSpeed.scrollableValue = 16;
        this.generatedSpeed.withUnit(i -> Lang.translate("generic.unit.rpm", new Object[0]));
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        this.generatedSpeed.withStepFunction(CreativeMotorTileEntity::step);
        behaviours.add(this.generatedSpeed);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        if (!AllBlocks.CREATIVE_MOTOR.has(this.func_195044_w())) {
            return 0.0f;
        }
        return CreativeMotorTileEntity.convertToDirection(this.generatedSpeed.getValue(), (Direction)this.func_195044_w().func_177229_b((IProperty)CreativeMotorBlock.FACING));
    }

    public static int step(ScrollValueBehaviour.StepContext context) {
        if (context.shift) {
            return 1;
        }
        int current = context.currentValue;
        int magnitude = Math.abs(current) - (context.forward == current > 0 ? 0 : 1);
        int step = 1;
        if (magnitude >= 4) {
            step *= 4;
        }
        if (magnitude >= 32) {
            step *= 4;
        }
        if (magnitude >= 128) {
            step *= 4;
        }
        return step;
    }
}

