/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.saw;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.MathHelper;

public class SawRenderer
extends SafeTileEntityRenderer<SawTileEntity> {
    public SawRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(SawTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        this.renderItems(te, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnTileEntity(te, partialTicks, ms, buffer, light, overlay);
        this.renderShaft(te, ms, buffer, light, overlay);
    }

    protected void renderShaft(SawTileEntity te, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        KineticTileEntityRenderer.renderRotatingBuffer(te, this.getRotatedModel(te), ms, buffer.getBuffer(RenderType.func_228639_c_()), light);
    }

    protected void renderItems(SawTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        boolean processingMode;
        boolean bl = processingMode = te.func_195044_w().func_177229_b((IProperty)SawBlock.FACING) == Direction.UP;
        if (processingMode && !te.inventory.isEmpty()) {
            float offset;
            boolean alongZ = (Boolean)te.func_195044_w().func_177229_b((IProperty)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
            ms.func_227860_a_();
            boolean moving = te.inventory.recipeDuration != 0.0f;
            float f = offset = moving ? te.inventory.remainingTime / te.inventory.recipeDuration : 0.0f;
            if (moving) {
                offset = MathHelper.func_76131_a((float)(offset + (-partialTicks + 0.5f) / te.inventory.recipeDuration), (float)0.0f, (float)1.0f);
            }
            if (te.getSpeed() == 0.0f) {
                offset = 0.5f;
            }
            if (te.getSpeed() < 0.0f ^ alongZ) {
                offset = 1.0f - offset;
            }
            ItemStack stack = te.inventory.getStackInSlot(0);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            IBakedModel modelWithOverrides = itemRenderer.func_184393_a(stack, te.func_145831_w(), null);
            boolean blockItem = modelWithOverrides.func_177556_c();
            ms.func_227861_a_(alongZ ? (double)offset : 0.5, blockItem ? (double)0.925f : 0.8125, alongZ ? 0.5 : (double)offset);
            ms.func_227862_a_(0.5f, 0.5f, 0.5f);
            if (alongZ) {
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            }
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            itemRenderer.func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
            ms.func_227865_b_();
        }
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        BlockState state = te.func_195044_w();
        if (((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k().func_176722_c()) {
            return AllBlockPartials.SHAFT_HALF.renderOnDirectional(state.func_185907_a(Rotation.CLOCKWISE_180));
        }
        return CreateClient.bufferCache.renderBlockIn(KineticTileEntityRenderer.KINETIC_TILE, this.getRenderedBlockState(te));
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return KineticTileEntityRenderer.shaft(KineticTileEntityRenderer.getRotationAxisOf(te));
    }
}

