/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.foundation.utility.SuperByteBufferCache;
import com.simibubi.create.foundation.utility.TileEntityRenderHelper;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class ContraptionRenderer {
    public static final SuperByteBufferCache.Compartment<Contraption> CONTRAPTION = new SuperByteBufferCache.Compartment();
    protected static PlacementSimulationWorld renderWorld;

    public static void render(World world, Contraption c, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        ContraptionRenderer.renderStructure(world, c, ms, msLocal, buffer);
        ContraptionRenderer.renderTileEntities(world, c, ms, msLocal, buffer);
        ContraptionRenderer.renderActors(world, c, ms, msLocal, buffer);
    }

    protected static void renderStructure(World world, Contraption c, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        IVertexBuilder translucent = buffer.getBuffer(RenderType.func_228645_f_());
        SuperByteBuffer contraptionBuffer = CreateClient.bufferCache.get(CONTRAPTION, c, () -> ContraptionRenderer.buildStructureBuffer(c));
        Matrix4f model = msLocal.func_227866_c_().func_227870_a_();
        contraptionBuffer.light(model).renderInto(ms, translucent);
    }

    private static void renderTileEntities(World world, Contraption c, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        TileEntityRenderHelper.renderTileEntities(world, c.customRenderTEs, ms, msLocal, buffer);
    }

    private static SuperByteBuffer buildStructureBuffer(Contraption c) {
        if (renderWorld == null || renderWorld.func_201672_e() != Minecraft.func_71410_x().field_71441_e) {
            renderWorld = new PlacementSimulationWorld((World)Minecraft.func_71410_x().field_71441_e);
        }
        MatrixStack ms = new MatrixStack();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
        Random random = new Random();
        BufferBuilder builder = new BufferBuilder(DefaultVertexFormats.field_176600_a.func_181719_f());
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (Template.BlockInfo info : c.blocks.values()) {
            renderWorld.func_175656_a(info.field_186242_a, info.field_186243_b);
        }
        for (BlockPos pos : c.renderOrder) {
            Template.BlockInfo info = c.blocks.get(pos);
            BlockState state = info.field_186243_b;
            if (state.func_185901_i() == BlockRenderType.ENTITYBLOCK_ANIMATED) continue;
            IBakedModel originalModel = dispatcher.func_184389_a(state);
            ms.func_227860_a_();
            ms.func_227861_a_((double)info.field_186242_a.func_177958_n(), (double)info.field_186242_a.func_177956_o(), (double)info.field_186242_a.func_177952_p());
            blockRenderer.renderModel((ILightReader)renderWorld, originalModel, state, info.field_186242_a, ms, (IVertexBuilder)builder, true, random, 42L, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            ms.func_227865_b_();
        }
        builder.func_178977_d();
        renderWorld.clear();
        return new SuperByteBuffer(builder);
    }

    private static void renderActors(World world, Contraption c, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        MatrixStack[] matrixStacks = new MatrixStack[]{ms, msLocal};
        for (Pair pair : c.getActors()) {
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = world;
            }
            Template.BlockInfo blockInfo = (Template.BlockInfo)pair.getLeft();
            for (MatrixStack m : matrixStacks) {
                m.func_227860_a_();
                MatrixStacker.of(m).translate((Vec3i)blockInfo.field_186242_a);
            }
            Contraption.getMovement(blockInfo.field_186243_b).renderInContraption(context, ms, msLocal, buffer);
            for (MatrixStack m : matrixStacks) {
                m.func_227865_b_();
            }
        }
    }

    public static int getLight(World world, float lx, float ly, float lz) {
        float offset;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        float sky = 0.0f;
        float block = 0.0f;
        for (float zOffset = offset = 0.125f; zOffset >= -offset; zOffset -= 2.0f * offset) {
            for (float yOffset = offset; yOffset >= -offset; yOffset -= 2.0f * offset) {
                for (float xOffset = offset; xOffset >= -offset; xOffset -= 2.0f * offset) {
                    pos.func_189532_c((double)(lx + xOffset), (double)(ly + yOffset), (double)(lz + zOffset));
                    sky += (float)world.func_226658_a_(LightType.SKY, (BlockPos)pos) / 8.0f;
                    block += (float)world.func_226658_a_(LightType.BLOCK, (BlockPos)pos) / 8.0f;
                }
            }
        }
        return (int)sky << 20 | (int)block << 4;
    }
}

