/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.foundation.utility.DirectionHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BellAttachment;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class StructureTransform {
    Rotation rotation;
    int angle;
    Direction.Axis rotationAxis;
    BlockPos offset;

    public StructureTransform(BlockPos offset, Vec3d rotation) {
        this.offset = offset;
        if (rotation.field_72450_a != 0.0) {
            this.rotationAxis = Direction.Axis.X;
            this.angle = (int)(Math.round(rotation.field_72450_a / 90.0) * 90L);
        }
        if (rotation.field_72448_b != 0.0) {
            this.rotationAxis = Direction.Axis.Y;
            this.angle = (int)(Math.round(rotation.field_72448_b / 90.0) * 90L);
        }
        if (rotation.field_72449_c != 0.0) {
            this.rotationAxis = Direction.Axis.Z;
            this.angle = (int)(Math.round(rotation.field_72449_c / 90.0) * 90L);
        }
        this.angle %= 360;
        if (this.angle < -90) {
            this.angle += 360;
        }
        this.rotation = Rotation.NONE;
        if (this.angle == -90 || this.angle == 270) {
            this.rotation = Rotation.CLOCKWISE_90;
        }
        if (this.angle == 90) {
            this.rotation = Rotation.COUNTERCLOCKWISE_90;
        }
        if (this.angle == 180) {
            this.rotation = Rotation.CLOCKWISE_180;
        }
    }

    public BlockPos apply(BlockPos localPos) {
        Vec3d vec = VecHelper.getCenterOf((Vec3i)localPos);
        vec = VecHelper.rotateCentered(vec, this.angle, this.rotationAxis);
        localPos = new BlockPos(vec);
        return localPos.func_177971_a((Vec3i)this.offset);
    }

    public BlockState apply(BlockState state) {
        Block block = state.func_177230_c();
        if (this.rotationAxis == Direction.Axis.Y) {
            if (block instanceof BellBlock) {
                if (state.func_177229_b((IProperty)BlockStateProperties.field_222511_P) == BellAttachment.DOUBLE_WALL) {
                    state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_222511_P, (Comparable)BellAttachment.SINGLE_WALL);
                }
                return (BlockState)state.func_206870_a((IProperty)HorizontalFaceBlock.field_185512_D, (Comparable)this.rotation.func_185831_a((Direction)state.func_177229_b((IProperty)HorizontalFaceBlock.field_185512_D)));
            }
            return state.func_185907_a(this.rotation);
        }
        if (block instanceof AbstractChassisBlock) {
            return this.rotateChassis(state);
        }
        if (block instanceof HorizontalFaceBlock) {
            Direction forcedAxis;
            Direction stateFacing = (Direction)state.func_177229_b((IProperty)HorizontalFaceBlock.field_185512_D);
            AttachFace stateFace = (AttachFace)state.func_177229_b((IProperty)HorizontalFaceBlock.field_196366_M);
            Direction direction = forcedAxis = this.rotationAxis == Direction.Axis.Z ? Direction.EAST : Direction.SOUTH;
            if (stateFacing.func_176740_k() == this.rotationAxis && stateFace == AttachFace.WALL) {
                return state;
            }
            for (int i = 0; i < this.rotation.ordinal(); ++i) {
                stateFace = (AttachFace)state.func_177229_b((IProperty)HorizontalFaceBlock.field_196366_M);
                stateFacing = (Direction)state.func_177229_b((IProperty)HorizontalFaceBlock.field_185512_D);
                boolean b = state.func_177229_b((IProperty)HorizontalFaceBlock.field_196366_M) == AttachFace.CEILING;
                state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)(b ? forcedAxis : forcedAxis.func_176734_d()));
                state = stateFace != AttachFace.WALL ? (BlockState)state.func_206870_a((IProperty)HorizontalFaceBlock.field_196366_M, (Comparable)AttachFace.WALL) : (stateFacing.func_176743_c() == Direction.AxisDirection.POSITIVE ? (BlockState)state.func_206870_a((IProperty)HorizontalFaceBlock.field_196366_M, (Comparable)AttachFace.FLOOR) : (BlockState)state.func_206870_a((IProperty)HorizontalFaceBlock.field_196366_M, (Comparable)AttachFace.CEILING));
            }
            return state;
        }
        if (block instanceof StairsBlock) {
            if (((Direction)state.func_177229_b((IProperty)StairsBlock.field_176309_a)).func_176740_k() != this.rotationAxis) {
                for (int i = 0; i < this.rotation.ordinal(); ++i) {
                    Direction direction = (Direction)state.func_177229_b((IProperty)StairsBlock.field_176309_a);
                    Half half = (Half)state.func_177229_b((IProperty)StairsBlock.field_176308_b);
                    state = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ^ half == Half.BOTTOM ^ direction.func_176740_k() == Direction.Axis.Z ? (BlockState)state.func_177231_a((IProperty)StairsBlock.field_176308_b) : (BlockState)state.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)direction.func_176734_d());
                }
            } else if (this.rotation == Rotation.CLOCKWISE_180) {
                state = (BlockState)state.func_177231_a((IProperty)StairsBlock.field_176308_b);
            }
            return state;
        }
        if (AllBlocks.BELT.has(state)) {
            if (((Direction)state.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176740_k() != this.rotationAxis) {
                for (int i = 0; i < this.rotation.ordinal(); ++i) {
                    BeltBlock.Slope slope = (BeltBlock.Slope)((Object)state.func_177229_b(BeltBlock.SLOPE));
                    Direction direction = (Direction)state.func_177229_b(BeltBlock.HORIZONTAL_FACING);
                    if (slope != BeltBlock.Slope.HORIZONTAL && slope != BeltBlock.Slope.VERTICAL) {
                        if (direction.func_176743_c() == Direction.AxisDirection.POSITIVE ^ slope == BeltBlock.Slope.DOWNWARD ^ direction.func_176740_k() == Direction.Axis.Z) {
                            state = (BlockState)state.func_206870_a(BeltBlock.SLOPE, (Comparable)((Object)(slope == BeltBlock.Slope.UPWARD ? BeltBlock.Slope.DOWNWARD : BeltBlock.Slope.UPWARD)));
                            continue;
                        }
                        state = (BlockState)state.func_206870_a(BeltBlock.HORIZONTAL_FACING, (Comparable)direction.func_176734_d());
                        continue;
                    }
                    if (slope == BeltBlock.Slope.HORIZONTAL ^ direction.func_176740_k() == Direction.Axis.Z) {
                        state = (BlockState)state.func_206870_a(BeltBlock.HORIZONTAL_FACING, (Comparable)direction.func_176734_d());
                    }
                    state = (BlockState)state.func_206870_a(BeltBlock.SLOPE, (Comparable)((Object)(slope == BeltBlock.Slope.HORIZONTAL ? BeltBlock.Slope.VERTICAL : BeltBlock.Slope.HORIZONTAL)));
                }
            } else if (this.rotation == Rotation.CLOCKWISE_180) {
                BeltBlock.Slope slope = (BeltBlock.Slope)((Object)state.func_177229_b(BeltBlock.SLOPE));
                Direction direction = (Direction)state.func_177229_b(BeltBlock.HORIZONTAL_FACING);
                if (slope == BeltBlock.Slope.UPWARD || slope == BeltBlock.Slope.DOWNWARD) {
                    state = (BlockState)state.func_206870_a(BeltBlock.SLOPE, (Comparable)((Object)(slope == BeltBlock.Slope.UPWARD ? BeltBlock.Slope.DOWNWARD : (slope == BeltBlock.Slope.DOWNWARD ? BeltBlock.Slope.UPWARD : slope))));
                } else if (slope == BeltBlock.Slope.VERTICAL) {
                    state = (BlockState)state.func_206870_a(BeltBlock.HORIZONTAL_FACING, (Comparable)direction.func_176734_d());
                }
            }
            return state;
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            Direction newFacing = this.transformFacing((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H));
            if (state.func_196959_b((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) && this.rotationAxis == newFacing.func_176740_k() && this.rotation.ordinal() % 2 == 1) {
                state = (BlockState)state.func_177231_a((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            }
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)newFacing);
        } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208148_A)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)this.transformAxis((Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208148_A)));
        } else if (this.rotation == Rotation.CLOCKWISE_180) {
            Direction stateFacing;
            if (state.func_196959_b((IProperty)BlockStateProperties.field_208155_H) && (stateFacing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k() == this.rotationAxis) {
                return state;
            }
            if (state.func_196959_b((IProperty)BlockStateProperties.field_208157_J) && (stateFacing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176740_k() == this.rotationAxis) {
                return state;
            }
            if ((state = state.func_185907_a(this.rotation)).func_196959_b((IProperty)SlabBlock.field_196505_a) && state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE) {
                state = (BlockState)state.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)(state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM));
            }
        }
        return state;
    }

    public Direction.Axis transformAxis(Direction.Axis axisIn) {
        Direction facing = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axisIn);
        facing = this.transformFacing(facing);
        Direction.Axis axis = facing.func_176740_k();
        return axis;
    }

    public Direction transformFacing(Direction facing) {
        for (int i = 0; i < this.rotation.ordinal(); ++i) {
            facing = DirectionHelper.rotateAround(facing, this.rotationAxis);
        }
        return facing;
    }

    private BlockState rotateChassis(BlockState state) {
        BooleanProperty glueableSide;
        if (this.rotation == Rotation.NONE) {
            return state;
        }
        BlockState rotated = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)this.transformAxis((Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208148_A)));
        AbstractChassisBlock block = (AbstractChassisBlock)state.func_177230_c();
        for (Direction face : Direction.values()) {
            glueableSide = block.getGlueableSide(rotated, face);
            if (glueableSide == null) continue;
            rotated = (BlockState)rotated.func_206870_a((IProperty)glueableSide, (Comparable)Boolean.valueOf(false));
        }
        for (Direction face : Direction.values()) {
            Direction rotatedFacing;
            BooleanProperty rotatedGlueableSide;
            glueableSide = block.getGlueableSide(state, face);
            if (glueableSide == null || !((Boolean)state.func_177229_b((IProperty)glueableSide)).booleanValue() || (rotatedGlueableSide = block.getGlueableSide(rotated, rotatedFacing = this.transformFacing(face))) == null) continue;
            rotated = (BlockState)rotated.func_206870_a((IProperty)rotatedGlueableSide, (Comparable)Boolean.valueOf(true));
        }
        return rotated;
    }
}

