/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.content.contraptions.components.structureMovement.AllContraptionTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ClockworkContraption
extends Contraption {
    protected Direction facing;
    public HandType handType;
    public int offset;
    private Set<BlockPos> ignoreBlocks = new HashSet<BlockPos>();

    @Override
    protected AllContraptionTypes getType() {
        return AllContraptionTypes.CLOCKWORK;
    }

    private void ignoreBlocks(Set<BlockPos> blocks, BlockPos anchor) {
        for (BlockPos blockPos : blocks) {
            this.ignoreBlocks.add(anchor.func_177971_a((Vec3i)blockPos));
        }
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor.func_177967_a(this.facing.func_176734_d(), this.offset + 1));
    }

    public static Pair<ClockworkContraption, ClockworkContraption> assembleClockworkAt(World world, BlockPos pos, Direction direction) {
        if (ClockworkContraption.isFrozen()) {
            return null;
        }
        int hourArmBlocks = 0;
        ClockworkContraption hourArm = new ClockworkContraption();
        ClockworkContraption minuteArm = null;
        hourArm.facing = direction;
        hourArm.handType = HandType.HOUR;
        if (!hourArm.searchMovedStructure(world, pos, direction)) {
            return null;
        }
        for (int i = 0; i < 16; ++i) {
            BlockPos offsetPos = BlockPos.field_177992_a.func_177967_a(direction, i);
            if (hourArm.blocks.containsKey(offsetPos)) continue;
            hourArmBlocks = i;
            break;
        }
        if (hourArmBlocks > 0) {
            minuteArm = new ClockworkContraption();
            minuteArm.facing = direction;
            minuteArm.handType = HandType.MINUTE;
            minuteArm.offset = hourArmBlocks;
            minuteArm.ignoreBlocks(hourArm.blocks.keySet(), hourArm.anchor);
            if (!minuteArm.searchMovedStructure(world, pos, direction)) {
                return null;
            }
            if (minuteArm.blocks.isEmpty()) {
                minuteArm = null;
            }
        }
        hourArm.initActors(world);
        hourArm.expandBoundsAroundAxis(direction.func_176740_k());
        if (minuteArm != null) {
            minuteArm.initActors(world);
            minuteArm.expandBoundsAroundAxis(direction.func_176740_k());
        }
        return Pair.of((Object)hourArm, (Object)minuteArm);
    }

    @Override
    public boolean searchMovedStructure(World world, BlockPos pos, Direction direction) {
        return super.searchMovedStructure(world, pos.func_177967_a(direction, this.offset + 1), null);
    }

    @Override
    protected boolean moveBlock(World world, BlockPos pos, Direction direction, List<BlockPos> frontier, Set<BlockPos> visited) {
        if (this.ignoreBlocks.contains(pos)) {
            return true;
        }
        return super.moveBlock(world, pos, direction, frontier, visited);
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT tag = super.writeNBT();
        tag.func_74768_a("facing", this.facing.func_176745_a());
        tag.func_74768_a("offset", this.offset);
        tag.func_74778_a("HandType", NBTHelper.writeEnum(this.handType));
        return tag;
    }

    @Override
    public void readNBT(World world, CompoundNBT tag) {
        this.facing = Direction.func_82600_a((int)tag.func_74762_e("Facing"));
        this.handType = NBTHelper.readEnum(tag.func_74779_i("HandType"), HandType.class);
        this.offset = tag.func_74762_e("offset");
        super.readNBT(world, tag);
    }

    public static enum HandType {
        HOUR,
        MINUTE;

    }
}

