/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.pulley;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyTileEntity;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;

public class PulleyRenderer
extends KineticTileEntityRenderer {
    public PulleyRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        PulleyTileEntity pulley = (PulleyTileEntity)te;
        BlockState blockState = te.func_195044_w();
        BlockPos pos = te.func_174877_v();
        SuperByteBuffer halfMagnet = AllBlockPartials.ROPE_HALF_MAGNET.renderOn(blockState);
        SuperByteBuffer halfRope = AllBlockPartials.ROPE_HALF.renderOn(blockState);
        SuperByteBuffer magnet = CreateClient.bufferCache.renderBlock(AllBlocks.PULLEY_MAGNET.getDefaultState());
        SuperByteBuffer rope = CreateClient.bufferCache.renderBlock(AllBlocks.ROPE.getDefaultState());
        boolean moving = pulley.running && (pulley.movedContraption == null || !pulley.movedContraption.isStalled());
        float offset = pulley.getInterpolatedOffset(moving ? partialTicks : 0.5f);
        if (pulley.movedContraption != null) {
            ContraptionEntity e = pulley.movedContraption;
            PulleyContraption c = (PulleyContraption)pulley.movedContraption.getContraption();
            double entityPos = MathHelper.func_219803_d((double)partialTicks, (double)e.field_70137_T, (double)e.func_226278_cu_());
            offset = (float)(-(entityPos - (double)c.getAnchor().func_177956_o() - (double)c.initialOffset));
        }
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        if (pulley.running || pulley.offset == 0.0f) {
            this.renderAt((IWorld)te.func_145831_w(), offset > 0.25f ? magnet : halfMagnet, offset, pos, ms, vb);
        }
        float f = offset % 1.0f;
        if (offset > 0.75f && (f < 0.25f || f > 0.75f)) {
            this.renderAt((IWorld)te.func_145831_w(), halfRope, f > 0.75f ? f - 1.0f : f, pos, ms, vb);
        }
        if (!pulley.running) {
            return;
        }
        int i = 0;
        while ((float)i < offset - 1.25f) {
            this.renderAt((IWorld)te.func_145831_w(), rope, offset - (float)i - 1.0f, pos, ms, vb);
            ++i;
        }
    }

    public void renderAt(IWorld world, SuperByteBuffer partial, float offset, BlockPos pulleyPos, MatrixStack ms, IVertexBuilder buffer) {
        BlockPos actualPos = pulleyPos.func_177979_c((int)offset);
        int light = WorldRenderer.func_228420_a_((ILightReader)world, (BlockState)world.func_180495_p(actualPos), (BlockPos)actualPos);
        partial.translate(0.0f, -offset, 0.0f).light(light).renderInto(ms, buffer);
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        BlockState blockState = te.func_195044_w();
        return AllBlockPartials.ROPE_COIL.renderOnDirectional(blockState, this.horizontalFacing(blockState));
    }

    public Direction horizontalFacing(BlockState blockState) {
        return Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)blockState.func_177229_b(PulleyBlock.HORIZONTAL_AXIS)));
    }
}

