/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.goggles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.gui.GuiGameElement;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GoggleOverlayRenderer {
    @SubscribeEvent
    public static void lookingAtBlocksThroughGogglesShowsTooltip(RenderGameOverlayEvent.Post event) {
        IHaveGoggleInformation gte;
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
        if (!(objectMouseOver instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)objectMouseOver;
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        BlockPos pos = result.func_216350_a();
        ItemStack goggles = mc.field_71439_g.func_184582_a(EquipmentSlotType.HEAD);
        TileEntity te = world.func_175625_s(pos);
        boolean goggleInformation = te instanceof IHaveGoggleInformation;
        boolean hoveringInformation = te instanceof IHaveHoveringInformation;
        if (!goggleInformation && !hoveringInformation) {
            return;
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        if (goggleInformation && AllItems.GOGGLES.isIn(goggles) && !(gte = (IHaveGoggleInformation)te).addToGoggleTooltip(tooltip, mc.field_71439_g.func_225608_bj_())) {
            goggleInformation = false;
        }
        if (hoveringInformation) {
            IHaveHoveringInformation hte;
            boolean goggleAddedInformation;
            boolean bl = goggleAddedInformation = !tooltip.isEmpty();
            if (goggleAddedInformation) {
                tooltip.add("");
            }
            if (!(hte = (IHaveHoveringInformation)te).addToTooltip(tooltip, mc.field_71439_g.func_225608_bj_())) {
                hoveringInformation = false;
            }
            if (goggleAddedInformation && !hoveringInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (!goggleInformation && !hoveringInformation) {
            return;
        }
        if (tooltip.isEmpty()) {
            return;
        }
        RenderSystem.pushMatrix();
        TooltipScreen tooltipScreen = new TooltipScreen(null);
        tooltipScreen.init(mc, mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p());
        tooltipScreen.renderTooltip(tooltip, tooltipScreen.width / 2, tooltipScreen.height / 2);
        ItemStack item = AllItems.GOGGLES.asStack();
        GuiGameElement.of(item).at(tooltipScreen.width / 2 + 10, tooltipScreen.height / 2 - 16).render();
        RenderSystem.popMatrix();
    }

    private static final class TooltipScreen
    extends Screen {
        private TooltipScreen(ITextComponent p_i51108_1_) {
            super(p_i51108_1_);
        }

        public void init(Minecraft mc, int width, int height) {
            this.minecraft = mc;
            this.itemRenderer = mc.func_175599_af();
            this.font = mc.field_71466_p;
            this.width = width;
            this.height = height;
        }
    }
}

