/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.content.contraptions.processing.BasinOperatingTileEntity;
import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BasinTileEntity
extends SyncedTileEntity
implements ITickableTileEntity {
    public boolean contentsChanged = true;
    protected ItemStackHandler outputInventory = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            BasinTileEntity.this.sendData();
            BasinTileEntity.this.func_70296_d();
        }
    };
    protected ItemStackHandler inputInventory = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            BasinTileEntity.this.contentsChanged = true;
            BasinTileEntity.this.sendData();
            BasinTileEntity.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack stackInSlot = this.getStackInSlot(i);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot) || stackInSlot.func_190916_E() != this.getStackLimit(i, stackInSlot)) continue;
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    protected LazyOptional<IItemHandlerModifiable> inventory = LazyOptional.of(() -> new BasinInventory(this.inputInventory, this.outputInventory));
    public BasinInputInventory recipeInventory = new BasinInputInventory();

    public BasinTileEntity(TileEntityType<? extends BasinTileEntity> type) {
        super(type);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inputInventory.deserializeNBT(compound.func_74775_l("InputItems"));
        this.outputInventory.deserializeNBT(compound.func_74775_l("OutputItems"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("InputItems", (INBT)this.inputInventory.serializeNBT());
        compound.func_218657_a("OutputItems", (INBT)this.outputInventory.serializeNBT());
        return compound;
    }

    public void onEmptied() {
        this.getOperator().ifPresent(te -> {
            te.basinRemoved = true;
        });
    }

    public void func_145843_s() {
        this.onEmptied();
        this.inventory.invalidate();
        super.func_145843_s();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        if (!this.contentsChanged) {
            return;
        }
        this.contentsChanged = false;
        this.getOperator().ifPresent(te -> te.basinChecker.scheduleUpdate());
    }

    private Optional<BasinOperatingTileEntity> getOperator() {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(2));
        if (te instanceof BasinOperatingTileEntity) {
            return Optional.of((BasinOperatingTileEntity)te);
        }
        return Optional.empty();
    }

    public static class BasinInventory
    extends CombinedInvWrapper {
        public BasinInventory(ItemStackHandler input, ItemStackHandler output) {
            super(new IItemHandlerModifiable[]{input, output});
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.isInput(slot)) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isInput(slot)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public boolean isInput(int slot) {
            return this.getIndexForSlot(slot) == 0;
        }

        public IItemHandlerModifiable getInputHandler() {
            return this.itemHandler[0];
        }

        public IItemHandlerModifiable getOutputHandler() {
            return this.itemHandler[1];
        }
    }

    public class BasinInputInventory
    extends RecipeWrapper {
        public BasinInputInventory() {
            super((IItemHandlerModifiable)BasinTileEntity.this.inputInventory);
        }
    }
}

