/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.CasingBlock;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltShapes;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltMovementHandler;
import com.simibubi.create.content.contraptions.relays.elementary.ShaftBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.mutable.MutableInt;

public class BeltBlock
extends HorizontalKineticBlock
implements ITE<BeltTileEntity>,
ISpecialBlockItemRequirement {
    public static final IProperty<Slope> SLOPE = EnumProperty.func_177709_a((String)"slope", Slope.class);
    public static final IProperty<Part> PART = EnumProperty.func_177709_a((String)"part", Part.class);
    public static final BooleanProperty CASING = BooleanProperty.func_177716_a((String)"casing");

    public BeltBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(SLOPE, (Comparable)((Object)Slope.HORIZONTAL))).func_206870_a(PART, (Comparable)((Object)Part.START))).func_206870_a((IProperty)CASING, (Comparable)Boolean.valueOf(false)));
    }

    public void func_149666_a(ItemGroup p_149666_1_, NonNullList<ItemStack> p_149666_2_) {
        p_149666_2_.add((Object)AllItems.BELT_CONNECTOR.asStack());
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        if (face.func_176740_k() != this.getRotationAxis(state)) {
            return false;
        }
        try {
            return ((BeltTileEntity)this.getTileEntity((IBlockReader)world, pos)).hasPulley();
        }
        catch (ITE.TileEntityException tileEntityException) {
            return false;
        }
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176746_e().func_176740_k();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return AllItems.BELT_CONNECTOR.asStack();
    }

    public Material func_149688_o(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CASING) != false ? Material.field_151575_d : Material.field_151580_n;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileEntity;
        List drops = super.func_220076_a(state, builder);
        if (((Boolean)state.func_177229_b((IProperty)CASING)).booleanValue()) {
            drops.addAll(AllBlocks.BRASS_CASING.getDefaultState().func_215693_a(builder));
        }
        if ((tileEntity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h)) instanceof BeltTileEntity && ((BeltTileEntity)tileEntity).hasPulley()) {
            drops.addAll(AllBlocks.SHAFT.getDefaultState().func_215693_a(builder));
        }
        return drops;
    }

    public void func_220062_a(BlockState state, World worldIn, BlockPos pos, ItemStack stack) {
        BeltTileEntity controllerTE = BeltHelper.getControllerTE((IWorld)worldIn, pos);
        if (controllerTE == null) {
            return;
        }
        if (controllerTE.getInventory() == null) {
            return;
        }
        controllerTE.getInventory().ejectAll();
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        BlockPos entityPosition = entityIn.func_180425_c();
        BlockPos beltPos = null;
        if (AllBlocks.BELT.has(worldIn.func_180495_p(entityPosition))) {
            beltPos = entityPosition;
        } else if (AllBlocks.BELT.has(worldIn.func_180495_p(entityPosition.func_177977_b()))) {
            beltPos = entityPosition.func_177977_b();
        }
        if (beltPos == null) {
            return;
        }
        if (!(worldIn instanceof World)) {
            return;
        }
        this.func_196262_a(worldIn.func_180495_p(beltPos), (World)worldIn, beltPos, entityIn);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        BeltTileEntity belt;
        if (state.func_177229_b(SLOPE) == Slope.VERTICAL) {
            return;
        }
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            if (player.func_225608_bj_()) {
                return;
            }
            if (player.field_71075_bZ.field_75100_b) {
                return;
            }
        }
        if ((belt = BeltHelper.getSegmentTE((IWorld)worldIn, pos)) == null || belt.getSpeed() == 0.0f) {
            return;
        }
        if (entityIn instanceof ItemEntity && entityIn.func_70089_S()) {
            if (worldIn.field_72995_K) {
                return;
            }
            if (entityIn.func_213322_ci().field_72448_b > 0.0) {
                return;
            }
            this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
                ItemEntity itemEntity = (ItemEntity)entityIn;
                IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
                if (handler == null) {
                    return;
                }
                ItemStack remainder = handler.insertItem(0, itemEntity.func_92059_d().func_77946_l(), false);
                if (remainder.func_190926_b()) {
                    itemEntity.func_70106_y();
                }
            });
            return;
        }
        BeltTileEntity controller = BeltHelper.getControllerTE((IWorld)worldIn, pos);
        if (controller == null || controller.passengers == null) {
            return;
        }
        if (controller.passengers.containsKey(entityIn)) {
            BeltMovementHandler.TransportedEntityInfo info = controller.passengers.get(entityIn);
            if (info.getTicksSinceLastCollision() != 0 || pos.equals((Object)entityIn.func_180425_c())) {
                info.refresh(pos, state);
            }
        } else {
            controller.passengers.put(entityIn, new BeltMovementHandler.TransportedEntityInfo(pos, state));
            entityIn.field_70122_E = true;
        }
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateNeighbouringTunnel(worldIn, pos, state);
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> te.attachmentTracker.findAttachments((BeltTileEntity)te));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean isHand;
        if (player.func_225608_bj_() || !player.func_175142_cm()) {
            return ActionResultType.PASS;
        }
        ItemStack heldItem = player.func_184586_b(handIn);
        boolean isShaft = heldItem.func_77973_b() == ((ShaftBlock)AllBlocks.SHAFT.get()).func_199767_j();
        boolean isCasing = heldItem.func_77973_b() == ((CasingBlock)AllBlocks.BRASS_CASING.get()).func_199767_j();
        boolean isDye = Tags.Items.DYES.func_199685_a_((Object)heldItem.func_77973_b());
        boolean bl = isHand = heldItem.func_190926_b() && handIn == Hand.MAIN_HAND;
        if (isDye) {
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
                DyeColor dyeColor = DyeColor.getColor((ItemStack)heldItem);
                if (dyeColor == null) {
                    return;
                }
                te.applyColor(dyeColor);
            });
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        BeltTileEntity belt = BeltHelper.getSegmentTE((IWorld)worldIn, pos);
        if (belt == null) {
            return ActionResultType.PASS;
        }
        if (isHand) {
            BeltTileEntity controllerBelt = belt.getControllerTE();
            if (controllerBelt == null) {
                return ActionResultType.PASS;
            }
            if (controllerBelt.getInventory() == null) {
                return ActionResultType.PASS;
            }
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            controllerBelt.getInventory().forEachWithin((float)belt.index + 0.5f, 0.55f, transportedItemStack -> {
                player.field_71071_by.func_191975_a(worldIn, transportedItemStack.stack);
                return Collections.emptyList();
            });
        }
        if (isShaft) {
            if (state.func_177229_b(PART) != Part.MIDDLE) {
                return ActionResultType.PASS;
            }
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            KineticTileEntity.switchToBlockState(worldIn, pos, (BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.PULLEY)));
            return ActionResultType.SUCCESS;
        }
        if (isCasing) {
            if (((Boolean)state.func_177229_b((IProperty)CASING)).booleanValue()) {
                return ActionResultType.PASS;
            }
            if (state.func_177229_b(SLOPE) == Slope.VERTICAL) {
                return ActionResultType.PASS;
            }
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            KineticTileEntity.switchToBlockState(worldIn, pos, (BlockState)state.func_206870_a((IProperty)CASING, (Comparable)Boolean.valueOf(true)));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        boolean returnItem;
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        boolean bl = returnItem = player != null && !player.func_184812_l_();
        if (((Boolean)state.func_177229_b((IProperty)CASING)).booleanValue()) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            world.func_180501_a(context.func_195995_a(), (BlockState)state.func_206870_a((IProperty)CASING, (Comparable)Boolean.valueOf(false)), 3);
            if (returnItem) {
                player.field_71071_by.func_191975_a(world, AllBlocks.BRASS_CASING.asStack());
            }
            return ActionResultType.SUCCESS;
        }
        if (state.func_177229_b(PART) == Part.PULLEY) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            world.func_180501_a(context.func_195995_a(), (BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.MIDDLE)), 2);
            BeltTileEntity belt = BeltHelper.getSegmentTE((IWorld)world, context.func_195995_a());
            if (belt != null) {
                belt.detachKinetics();
                belt.attachKinetics();
            }
            if (returnItem) {
                player.field_71071_by.func_191975_a(world, AllBlocks.SHAFT.asStack());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SLOPE, PART, CASING});
        super.func_206840_a(builder);
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, MobEntity entity) {
        return PathNodeType.RAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        VoxelShape voxelshape = state.func_196954_c((IBlockReader)world, pos);
        MutableInt amtBoxes = new MutableInt(0);
        voxelshape.func_197755_b((x1, y1, z1, x2, y2, z2) -> amtBoxes.increment());
        double chance = 1.0 / (double)amtBoxes.getValue().intValue();
        voxelshape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            double d1 = Math.min(1.0, x2 - x1);
            double d2 = Math.min(1.0, y2 - y1);
            double d3 = Math.min(1.0, z2 - z1);
            int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
            int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
            int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        if (world.field_73012_v.nextDouble() > chance) continue;
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + x1;
                        double d8 = d5 * d2 + y1;
                        double d9 = d6 * d3 + z1;
                        manager.func_78873_a((Particle)new DiggingParticle(world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).func_174846_a(pos));
                    }
                }
            }
        });
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BeltShapes.getShape(state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177230_c() != this) {
            return VoxelShapes.func_197880_a();
        }
        VoxelShape shape = this.func_220053_a(state, worldIn, pos, context);
        try {
            if (context.getEntity() == null) {
                return shape;
            }
            BeltTileEntity belt = (BeltTileEntity)this.getTileEntity(worldIn, pos);
            BeltTileEntity controller = belt.getControllerTE();
            if (controller == null) {
                return shape;
            }
            if (controller.passengers == null || !controller.passengers.containsKey(context.getEntity())) {
                return BeltShapes.getCollisionShape(state);
            }
        }
        catch (ITE.TileEntityException tileEntityException) {
            // empty catch block
        }
        return shape;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.BELT.create();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CASING) != false && state.func_177229_b(SLOPE) != Slope.VERTICAL ? BlockRenderType.MODEL : BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public static void initBelt(World world, BlockPos pos) {
        if (world.field_72995_K || world.func_175624_G() == WorldType.field_180272_g) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (!AllBlocks.BELT.has(state)) {
            return;
        }
        int limit = 1000;
        BlockPos currentPos = pos;
        while (limit-- > 0) {
            BlockState currentState = world.func_180495_p(currentPos);
            if (!AllBlocks.BELT.has(currentState)) {
                world.func_175655_b(pos, true);
                return;
            }
            BlockPos nextSegmentPosition = BeltBlock.nextSegmentPosition(currentState, currentPos, false);
            if (nextSegmentPosition == null) break;
            if (!world.isAreaLoaded(nextSegmentPosition, 0)) {
                return;
            }
            currentPos = nextSegmentPosition;
        }
        int index = 0;
        List<BlockPos> beltChain = BeltBlock.getBeltChain(world, currentPos);
        if (beltChain.size() < 2) {
            world.func_175655_b(currentPos, true);
            return;
        }
        for (BlockPos beltPos : beltChain) {
            TileEntity tileEntity = world.func_175625_s(beltPos);
            BlockState currentState = world.func_180495_p(beltPos);
            if (tileEntity instanceof BeltTileEntity && AllBlocks.BELT.has(currentState)) {
                boolean isVertical;
                BeltTileEntity te = (BeltTileEntity)tileEntity;
                te.setController(currentPos);
                te.beltLength = beltChain.size();
                te.index = index;
                te.attachKinetics();
                te.func_70296_d();
                te.sendData();
                boolean bl = isVertical = currentState.func_177229_b(SLOPE) == Slope.VERTICAL;
                if (((Boolean)currentState.func_177229_b((IProperty)CASING)).booleanValue() && isVertical) {
                    Block.func_180635_a((World)world, (BlockPos)beltPos, (ItemStack)AllBlocks.BRASS_CASING.asStack());
                    world.func_180501_a(beltPos, (BlockState)currentState.func_206870_a((IProperty)CASING, (Comparable)Boolean.valueOf(false)), 2);
                }
                if (te.isController() && isVertical) {
                    te.getInventory().ejectAll();
                }
            } else {
                world.func_175655_b(currentPos, true);
                return;
            }
            ++index;
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        if (state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        this.updateNeighbouringTunnel(world, pos, state);
        if (isMoving) {
            return;
        }
        TileEntity belt = world.func_175625_s(pos);
        if (belt instanceof BeltTileEntity) {
            belt.func_145843_s();
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockState currentState;
            BlockPos currentPos = BeltBlock.nextSegmentPosition(state, pos, forward);
            if (currentPos == null || !AllBlocks.BELT.has(currentState = world.func_180495_p(currentPos))) continue;
            if (((Boolean)currentState.func_177229_b((IProperty)CASING)).booleanValue()) {
                Block.func_180635_a((World)world, (BlockPos)currentPos, (ItemStack)AllBlocks.BRASS_CASING.asStack());
            }
            boolean hasPulley = false;
            TileEntity tileEntity = world.func_175625_s(currentPos);
            if (tileEntity instanceof BeltTileEntity) {
                BeltTileEntity te = (BeltTileEntity)tileEntity;
                if (te.isController()) {
                    te.getInventory().ejectAll();
                }
                te.func_145843_s();
                hasPulley = te.hasPulley();
            }
            BlockState shaftState = (BlockState)AllBlocks.SHAFT.getDefaultState().func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)this.getRotationAxis(currentState));
            world.func_180501_a(currentPos, hasPulley ? shaftState : Blocks.field_150350_a.func_176223_P(), 3);
            world.func_217379_c(2001, currentPos, Block.func_196246_j((BlockState)currentState));
        }
    }

    private void updateNeighbouringTunnel(World world, BlockPos pos, BlockState beltState) {
        boolean isEnd;
        boolean bl = isEnd = beltState.func_177229_b(PART) != Part.END;
        if (isEnd && beltState.func_177229_b(PART) != Part.START) {
            return;
        }
        int offset = isEnd ? -1 : 1;
        BlockPos tunnelPos = pos.func_177967_a((Direction)beltState.func_177229_b(HORIZONTAL_FACING), offset).func_177984_a();
        if (AllBlocks.BELT_TUNNEL.has(world.func_180495_p(tunnelPos))) {
            BeltTunnelBlock.updateTunnel(world, tunnelPos);
        }
    }

    public static List<BlockPos> getBeltChain(World world, BlockPos controllerPos) {
        BlockState state;
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        BlockState blockState = world.func_180495_p(controllerPos);
        if (!AllBlocks.BELT.has(blockState)) {
            return positions;
        }
        int limit = 1000;
        BlockPos current = controllerPos;
        while (limit-- > 0 && current != null && AllBlocks.BELT.has(state = world.func_180495_p(current))) {
            positions.add(current);
            current = BeltBlock.nextSegmentPosition(state, current, true);
        }
        return positions;
    }

    public static BlockPos nextSegmentPosition(BlockState state, BlockPos pos, boolean forward) {
        int offset;
        Direction direction = (Direction)state.func_177229_b(HORIZONTAL_FACING);
        Slope slope = (Slope)((Object)state.func_177229_b(SLOPE));
        Part part = (Part)((Object)state.func_177229_b(PART));
        int n = offset = forward ? 1 : -1;
        if (part == Part.END && forward || part == Part.START && !forward) {
            return null;
        }
        if (slope == Slope.VERTICAL) {
            return pos.func_177981_b(direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? offset : -offset);
        }
        pos = pos.func_177967_a(direction, offset);
        if (slope != Slope.HORIZONTAL) {
            return pos.func_177981_b(slope == Slope.UPWARD ? offset : -offset);
        }
        return pos;
    }

    @Override
    protected boolean hasStaticPart() {
        return false;
    }

    public static boolean canAccessFromSide(Direction facing, BlockState belt) {
        if (facing == null) {
            return true;
        }
        if (!((Boolean)belt.func_177229_b((IProperty)CASING)).booleanValue()) {
            return false;
        }
        Part part = (Part)((Object)belt.func_177229_b(PART));
        if (part != Part.MIDDLE && facing.func_176740_k() == ((Direction)belt.func_177229_b(HORIZONTAL_FACING)).func_176746_e().func_176740_k()) {
            return false;
        }
        Slope slope = (Slope)((Object)belt.func_177229_b(SLOPE));
        if (slope != Slope.HORIZONTAL) {
            if (slope == Slope.DOWNWARD && part == Part.END) {
                return true;
            }
            if (slope == Slope.UPWARD && part == Part.START) {
                return true;
            }
            Direction beltSide = (Direction)belt.func_177229_b(HORIZONTAL_FACING);
            if (slope == Slope.DOWNWARD) {
                beltSide = beltSide.func_176734_d();
            }
            if (beltSide == facing) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Class<BeltTileEntity> getTileEntityClass() {
        return BeltTileEntity.class;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        if (state.func_177229_b(PART) != Part.MIDDLE) {
            required.add(AllBlocks.SHAFT.asStack());
        }
        if (((Boolean)state.func_177229_b((IProperty)CASING)).booleanValue()) {
            required.add(AllBlocks.BRASS_CASING.asStack());
        }
        if (state.func_177229_b(PART) == Part.START) {
            required.add(AllItems.BELT_CONNECTOR.asStack());
        }
        if (required.isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, required);
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        BlockState rotate = super.func_185499_a(state, rot);
        if (state.func_177229_b(SLOPE) != Slope.VERTICAL) {
            return rotate;
        }
        if (((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176743_c() != ((Direction)rotate.func_177229_b(HORIZONTAL_FACING)).func_176743_c()) {
            if (state.func_177229_b(PART) == Part.START) {
                return (BlockState)rotate.func_206870_a(PART, (Comparable)((Object)Part.END));
            }
            if (state.func_177229_b(PART) == Part.END) {
                return (BlockState)rotate.func_206870_a(PART, (Comparable)((Object)Part.START));
            }
        }
        return rotate;
    }

    public static enum Part implements IStringSerializable
    {
        START,
        MIDDLE,
        END,
        PULLEY;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }

    public static enum Slope implements IStringSerializable
    {
        HORIZONTAL,
        UPWARD,
        DOWNWARD,
        VERTICAL;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

