/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt.transport;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.relays.belt.AllBeltAttachments;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.ItemHandlerBeltSegment;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BeltInventory {
    final BeltTileEntity belt;
    private final List<TransportedItemStack> items;
    final List<TransportedItemStack> toInsert;
    boolean beltMovementPositive;
    final float SEGMENT_WINDOW = 0.75f;

    public BeltInventory(BeltTileEntity te) {
        this.belt = te;
        this.items = new LinkedList<TransportedItemStack>();
        this.toInsert = new LinkedList<TransportedItemStack>();
    }

    public void tick() {
        if (this.beltMovementPositive != this.movingPositive()) {
            this.beltMovementPositive = this.movingPositive();
            Collections.reverse(this.getItems());
            this.belt.func_70296_d();
            this.belt.sendData();
        }
        if (!this.toInsert.isEmpty()) {
            this.toInsert.forEach(this::insert);
            this.toInsert.clear();
            this.belt.func_70296_d();
            this.belt.sendData();
        }
        TransportedItemStack stackInFront = null;
        TransportedItemStack current = null;
        Iterator<TransportedItemStack> iterator = this.getItems().iterator();
        float beltSpeed = this.belt.getDirectionAwareBeltMovementSpeed();
        Direction movementFacing = this.belt.getMovementFacing();
        float spacing = 1.0f;
        boolean onClient = this.belt.func_145831_w().field_72995_K;
        block0: while (iterator.hasNext()) {
            BeltTileEntity nextBelt;
            Direction nextMovementFacing;
            stackInFront = current;
            current = iterator.next();
            current.prevBeltPosition = current.beltPosition;
            current.prevSideOffset = current.sideOffset;
            if (current.stack.func_190926_b()) {
                iterator.remove();
                current = null;
                continue;
            }
            float movement = beltSpeed;
            if (onClient) {
                movement *= ServerSpeedProvider.get();
            }
            if (onClient && current.locked) continue;
            float currentPos = current.beltPosition;
            if (stackInFront != null) {
                float diff = stackInFront.beltPosition - currentPos;
                if (Math.abs(diff) <= spacing) continue;
                movement = this.beltMovementPositive ? Math.min(movement, diff - spacing) : Math.max(movement, diff + spacing);
            }
            int segmentBefore = (int)currentPos;
            float min = (float)segmentBefore + 0.5f - 0.375f;
            float max = (float)segmentBefore + 0.5f + 0.375f;
            if (currentPos < min || currentPos > max) {
                segmentBefore = -1;
            }
            float diffToEnd = this.beltMovementPositive ? (float)this.belt.beltLength - currentPos : -currentPos;
            float limitedMovement = this.beltMovementPositive ? Math.min(movement, diffToEnd) : Math.max(movement, diffToEnd);
            float nextOffset = current.beltPosition + limitedMovement;
            if (!onClient && segmentBefore != -1) {
                BeltTileEntity beltSegment;
                if (current.locked && (beltSegment = BeltHelper.getBeltAtSegment(this.belt, segmentBefore)) != null) {
                    if (current.locked && beltSegment.trackerUpdateTag != null) continue;
                    current.locked = false;
                    List<AllBeltAttachments.BeltAttachmentState> attachments = beltSegment.attachmentTracker.attachments;
                    for (AllBeltAttachments.BeltAttachmentState attachmentState : attachments) {
                        if (!attachmentState.attachment.processItem(beltSegment, current, attachmentState)) continue;
                        current.locked = true;
                    }
                    if (current.locked && !current.stack.func_190926_b()) continue;
                    if (!attachments.isEmpty()) {
                        attachments.add(attachments.remove(0));
                    }
                    this.belt.sendData();
                    continue;
                }
                if (current.beltPosition > 0.5f || this.beltMovementPositive) {
                    BeltTileEntity beltSegment2;
                    int firstUpcomingSegment;
                    int segment = firstUpcomingSegment = (int)(current.beltPosition + (this.beltMovementPositive ? 0.5f : -0.5f));
                    while ((this.beltMovementPositive ? (float)segment + 0.5f <= nextOffset : (float)segment + 0.5f >= nextOffset) && (beltSegment2 = BeltHelper.getBeltAtSegment(this.belt, segment)) != null) {
                        for (AllBeltAttachments.BeltAttachmentState attachmentState : beltSegment2.attachmentTracker.attachments) {
                            ItemStack stackBefore = current.stack.func_77946_l();
                            if (attachmentState.attachment.startProcessingItem(beltSegment2, current, attachmentState)) {
                                current.beltPosition = (float)segment + 0.5f + (this.beltMovementPositive ? 0.015625f : -0.015625f);
                                current.locked = true;
                                this.belt.sendData();
                                continue block0;
                            }
                            if (stackBefore.equals(current.stack, true)) continue;
                            this.belt.sendData();
                        }
                        segment += this.beltMovementPositive ? 1 : -1;
                    }
                }
            }
            int seg1 = (int)current.beltPosition;
            int seg2 = (int)nextOffset;
            if (!this.beltMovementPositive && nextOffset == 0.0f) {
                seg2 = -1;
            }
            if (seg1 != seg2) {
                if (this.stuckAtTunnel(seg2, current.stack, movementFacing)) continue;
                if (!onClient) {
                    this.flapTunnel(seg1, movementFacing, false);
                    this.flapTunnel(seg2, movementFacing.func_176734_d(), true);
                }
            }
            current.beltPosition += limitedMovement;
            current.sideOffset += (current.getTargetSideOffset() - current.sideOffset) * Math.abs(limitedMovement) * 2.0f;
            currentPos = current.beltPosition;
            int segmentAfter = (int)currentPos;
            min = (float)segmentAfter + 0.5f - 0.375f;
            max = (float)segmentAfter + 0.5f + 0.375f;
            if (currentPos < min || currentPos > max) {
                segmentAfter = -1;
            }
            World world = this.belt.func_145831_w();
            if (segmentBefore != segmentAfter) {
                for (int segment : new int[]{segmentBefore, segmentAfter}) {
                    if (segment == -1 || world.field_72995_K) continue;
                    world.func_175666_e(BeltHelper.getPositionForOffset(this.belt, segment), this.belt.func_195044_w().func_177230_c());
                }
            }
            if (limitedMovement == movement || world.field_72995_K) continue;
            int lastOffset = this.beltMovementPositive ? this.belt.beltLength - 1 : 0;
            BlockPos nextPosition = BeltHelper.getPositionForOffset(this.belt, this.beltMovementPositive ? this.belt.beltLength : -1);
            BlockState state = world.func_180495_p(nextPosition);
            if (AllBlocks.BASIN.has(state) || AllBlocks.MECHANICAL_SAW.has(state) || AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(state)) {
                IItemHandler itemHandler;
                ItemStack remainder;
                LazyOptional optional;
                TileEntity te = world.func_175625_s(nextPosition);
                if (te == null || !(optional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP)).isPresent() || (remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)(itemHandler = (IItemHandler)optional.orElse(null)), (ItemStack)current.stack.func_77946_l(), (boolean)false)).equals(current.stack, false)) continue;
                current.stack = remainder;
                if (remainder.func_190926_b()) {
                    iterator.remove();
                    current = null;
                    this.flapTunnel(lastOffset, movementFacing, false);
                }
                this.belt.sendData();
                continue;
            }
            if (!AllBlocks.BELT.has(state) || state.func_177229_b(BeltBlock.SLOPE) == BeltBlock.Slope.VERTICAL) {
                if (Block.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)nextPosition, (Direction)movementFacing.func_176734_d())) continue;
                this.eject(current);
                iterator.remove();
                current = null;
                this.flapTunnel(lastOffset, movementFacing, false);
                this.belt.sendData();
                continue;
            }
            TileEntity te = world.func_175625_s(nextPosition);
            if (te == null || !(te instanceof BeltTileEntity) || (nextMovementFacing = (nextBelt = (BeltTileEntity)te).getMovementFacing()) == movementFacing.func_176734_d() || !nextBelt.tryInsertingFromSide(movementFacing, current, false)) continue;
            iterator.remove();
            current = null;
            this.flapTunnel(lastOffset, movementFacing, false);
            this.belt.sendData();
        }
    }

    private boolean stuckAtTunnel(int offset, ItemStack stack, Direction movementDirection) {
        BlockPos pos = BeltHelper.getPositionForOffset(this.belt, offset).func_177984_a();
        if (!AllBlocks.BELT_TUNNEL.has(this.belt.func_145831_w().func_180495_p(pos))) {
            return false;
        }
        TileEntity te = this.belt.func_145831_w().func_175625_s(pos);
        if (te == null || !(te instanceof BeltTunnelTileEntity)) {
            return false;
        }
        Direction flapFacing = movementDirection.func_176734_d();
        BeltTunnelTileEntity tunnel = (BeltTunnelTileEntity)te;
        if (!tunnel.flaps.containsKey(flapFacing)) {
            return false;
        }
        if (!tunnel.syncedFlaps.containsKey(flapFacing)) {
            return false;
        }
        ItemStack heldItem = tunnel.syncedFlaps.get(flapFacing);
        if (heldItem == null) {
            tunnel.syncedFlaps.put(flapFacing, ItemStack.field_190927_a);
            this.belt.sendData();
            return false;
        }
        if (heldItem == ItemStack.field_190927_a) {
            tunnel.syncedFlaps.put(flapFacing, stack);
            return true;
        }
        List<BeltTunnelTileEntity> group = BeltTunnelBlock.getSynchronizedGroup(this.belt.func_145831_w(), pos, flapFacing);
        for (BeltTunnelTileEntity otherTunnel : group) {
            if (otherTunnel.syncedFlaps.get(flapFacing) != ItemStack.field_190927_a) continue;
            return true;
        }
        for (BeltTunnelTileEntity otherTunnel : group) {
            otherTunnel.syncedFlaps.put(flapFacing, null);
        }
        return true;
    }

    private void flapTunnel(int offset, Direction side, boolean inward) {
        if (this.belt.func_195044_w().func_177229_b(BeltBlock.SLOPE) != BeltBlock.Slope.HORIZONTAL) {
            return;
        }
        BlockPos pos = BeltHelper.getPositionForOffset(this.belt, offset).func_177984_a();
        if (!AllBlocks.BELT_TUNNEL.has(this.belt.func_145831_w().func_180495_p(pos))) {
            return;
        }
        TileEntity te = this.belt.func_145831_w().func_175625_s(pos);
        if (te == null || !(te instanceof BeltTunnelTileEntity)) {
            return;
        }
        ((BeltTunnelTileEntity)te).flap(side, inward ^ side.func_176740_k() == Direction.Axis.Z);
    }

    public boolean canInsertAt(int segment) {
        return this.canInsertFrom(segment, Direction.UP);
    }

    public boolean canInsertFrom(int segment, Direction side) {
        float segmentPos = segment;
        if (this.belt.getMovementFacing() == side.func_176734_d()) {
            return false;
        }
        if (this.belt.getMovementFacing() != side) {
            segmentPos += 0.5f;
        } else if (!this.beltMovementPositive) {
            segmentPos += 1.0f;
        }
        for (TransportedItemStack stack : this.getItems()) {
            if (!this.isBlocking(segment, side, segmentPos, stack)) continue;
            return false;
        }
        for (TransportedItemStack stack : this.toInsert) {
            if (!this.isBlocking(segment, side, segmentPos, stack)) continue;
            return false;
        }
        return true;
    }

    private boolean isBlocking(int segment, Direction side, float segmentPos, TransportedItemStack stack) {
        float currentPos = stack.beltPosition;
        return stack.insertedAt == segment && stack.insertedFrom == side && (this.beltMovementPositive ? currentPos <= segmentPos + 1.0f : currentPos >= segmentPos - 1.0f);
    }

    public void addItem(TransportedItemStack newStack) {
        this.toInsert.add(newStack);
    }

    private void insert(TransportedItemStack newStack) {
        if (this.getItems().isEmpty()) {
            this.getItems().add(newStack);
        } else {
            int index = 0;
            for (TransportedItemStack stack : this.getItems()) {
                if (stack.compareTo(newStack) > 0 == this.beltMovementPositive) break;
                ++index;
            }
            this.getItems().add(index, newStack);
        }
    }

    public TransportedItemStack getStackAtOffset(int offset) {
        float min = (float)offset + 0.5f - 0.375f;
        float max = (float)offset + 0.5f + 0.375f;
        for (TransportedItemStack stack : this.getItems()) {
            if (stack.beltPosition > max || !(stack.beltPosition > min)) continue;
            return stack;
        }
        return null;
    }

    public void read(CompoundNBT nbt) {
        this.getItems().clear();
        nbt.func_150295_c("Items", 10).forEach(inbt -> this.getItems().add(TransportedItemStack.read((CompoundNBT)inbt)));
        this.beltMovementPositive = nbt.func_74767_n("PositiveOrder");
    }

    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT itemsNBT = new ListNBT();
        this.getItems().forEach(stack -> itemsNBT.add((Object)stack.serializeNBT()));
        nbt.func_218657_a("Items", (INBT)itemsNBT);
        nbt.func_74757_a("PositiveOrder", this.beltMovementPositive);
        return nbt;
    }

    public void eject(TransportedItemStack stack) {
        ItemStack ejected = stack.stack;
        Vec3d outPos = BeltHelper.getVectorForOffset(this.belt, stack.beltPosition);
        float movementSpeed = Math.max(Math.abs(this.belt.getBeltMovementSpeed()), 0.125f);
        Vec3d outMotion = new Vec3d(this.belt.getBeltChainDirection()).func_186678_a((double)movementSpeed).func_72441_c(0.0, 0.125, 0.0);
        outPos.func_178787_e(outMotion.func_72432_b());
        ItemEntity entity = new ItemEntity(this.belt.func_145831_w(), outPos.field_72450_a, outPos.field_72448_b + 0.375, outPos.field_72449_c, ejected);
        entity.func_213317_d(outMotion);
        entity.func_174869_p();
        entity.field_70133_I = true;
        this.belt.func_145831_w().func_217376_c((Entity)entity);
    }

    public void ejectAll() {
        this.getItems().forEach(this::eject);
        this.getItems().clear();
    }

    private boolean movingPositive() {
        return this.belt.getDirectionAwareBeltMovementSpeed() > 0.0f;
    }

    public IItemHandler createHandlerForSegment(int segment) {
        return new ItemHandlerBeltSegment(this, segment);
    }

    public void forEachWithin(float position, float distance, Function<TransportedItemStack, List<TransportedItemStack>> callback) {
        ArrayList<TransportedItemStack> toBeAdded = new ArrayList<TransportedItemStack>();
        boolean dirty = false;
        Iterator<TransportedItemStack> iterator = this.getItems().iterator();
        while (iterator.hasNext()) {
            List<TransportedItemStack> apply;
            TransportedItemStack transportedItemStack = iterator.next();
            if (!(Math.abs(position - transportedItemStack.beltPosition) < distance) || (apply = callback.apply(transportedItemStack)) == null) continue;
            dirty = true;
            toBeAdded.addAll(apply);
            iterator.remove();
        }
        toBeAdded.forEach(this::insert);
        if (dirty) {
            this.belt.func_70296_d();
            this.belt.sendData();
        }
    }

    public List<TransportedItemStack> getItems() {
        return this.items;
    }
}

