/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry;

import com.simibubi.create.content.curiosities.symmetry.SymmetryEffectPacket;
import com.simibubi.create.content.curiosities.symmetry.SymmetryWandScreen;
import com.simibubi.create.content.curiosities.symmetry.mirror.CrossPlaneMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.EmptyMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.PlaneMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.SymmetryMirror;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.PacketDistributor;

public class SymmetryWandItem
extends Item {
    public static final String SYMMETRY = "symmetry";
    private static final String ENABLE = "enable";

    public SymmetryWandItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_208103_a(Rarity.UNCOMMON));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        BlockPos pos = context.func_195995_a();
        player.func_184811_cZ().func_185145_a((Item)this, 5);
        ItemStack wand = player.func_184586_b(context.func_221531_n());
        SymmetryWandItem.checkNBT(wand);
        if (player.func_225608_bj_()) {
            if (player.field_70170_p.field_72995_K) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openWandGUI(wand, context.func_221531_n()));
                player.func_184811_cZ().func_185145_a((Item)this, 5);
            }
            return ActionResultType.SUCCESS;
        }
        if (context.func_195991_k().field_72995_K || context.func_221531_n() != Hand.MAIN_HAND) {
            return ActionResultType.SUCCESS;
        }
        CompoundNBT compound = wand.func_77978_p().func_74775_l(SYMMETRY);
        pos = pos.func_177972_a(context.func_196000_l());
        SymmetryMirror previousElement = SymmetryMirror.fromNBT(compound);
        wand.func_77978_p().func_74757_a(ENABLE, true);
        Vec3d pos3d = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        SymmetryMirror newElement = new PlaneMirror(pos3d);
        if (previousElement instanceof EmptyMirror) {
            newElement.setOrientation(player.func_174811_aO() == Direction.NORTH || player.func_174811_aO() == Direction.SOUTH ? PlaneMirror.Align.XY.ordinal() : PlaneMirror.Align.YZ.ordinal());
            newElement.enable = true;
            wand.func_77978_p().func_74757_a(ENABLE, true);
        } else {
            previousElement.setPosition(pos3d);
            if (previousElement instanceof PlaneMirror) {
                previousElement.setOrientation(player.func_174811_aO() == Direction.NORTH || player.func_174811_aO() == Direction.SOUTH ? PlaneMirror.Align.XY.ordinal() : PlaneMirror.Align.YZ.ordinal());
            }
            if (previousElement instanceof CrossPlaneMirror) {
                float rotation = player.func_70079_am();
                float abs = Math.abs(rotation % 90.0f);
                boolean diagonal = abs > 22.0f && abs < 67.0f;
                previousElement.setOrientation(diagonal ? CrossPlaneMirror.Align.D.ordinal() : CrossPlaneMirror.Align.Y.ordinal());
            }
            newElement = previousElement;
        }
        compound = newElement.writeToNbt();
        wand.func_77978_p().func_218657_a(SYMMETRY, (INBT)compound);
        player.func_184611_a(context.func_221531_n(), wand);
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack wand = playerIn.func_184586_b(handIn);
        SymmetryWandItem.checkNBT(wand);
        if (playerIn.func_225608_bj_()) {
            if (worldIn.field_72995_K) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openWandGUI(playerIn.func_184586_b(handIn), handIn));
                playerIn.func_184811_cZ().func_185145_a((Item)this, 5);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)wand);
        }
        wand.func_77978_p().func_74757_a(ENABLE, false);
        return new ActionResult(ActionResultType.SUCCESS, (Object)wand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openWandGUI(ItemStack wand, Hand hand) {
        ScreenOpener.open(new SymmetryWandScreen(wand, hand));
    }

    private static void checkNBT(ItemStack wand) {
        if (!wand.func_77942_o() || !wand.func_77978_p().func_74764_b(SYMMETRY)) {
            wand.func_77982_d(new CompoundNBT());
            wand.func_77978_p().func_218657_a(SYMMETRY, (INBT)new EmptyMirror(new Vec3d(0.0, 0.0, 0.0)).writeToNbt());
            wand.func_77978_p().func_74757_a(ENABLE, false);
        }
    }

    public static boolean isEnabled(ItemStack stack) {
        SymmetryWandItem.checkNBT(stack);
        return stack.func_77978_p().func_74767_n(ENABLE);
    }

    public static SymmetryMirror getMirror(ItemStack stack) {
        SymmetryWandItem.checkNBT(stack);
        return SymmetryMirror.fromNBT(stack.func_77978_p().func_74775_l(SYMMETRY));
    }

    public static void apply(World world, ItemStack wand, PlayerEntity player, BlockPos pos, BlockState block) {
        SymmetryWandItem.checkNBT(wand);
        if (!SymmetryWandItem.isEnabled(wand)) {
            return;
        }
        if (!BlockItem.field_179220_a.containsKey(block.func_177230_c())) {
            return;
        }
        HashMap<BlockPos, BlockState> blockSet = new HashMap<BlockPos, BlockState>();
        blockSet.put(pos, block);
        SymmetryMirror symmetry = SymmetryMirror.fromNBT(wand.func_77978_p().func_74775_l(SYMMETRY));
        Vec3d mirrorPos = symmetry.getPosition();
        Vec3d vec3d = new Vec3d((Vec3i)pos);
        if (mirrorPos.func_72438_d(vec3d) > (double)((Integer)AllConfigs.SERVER.curiosities.maxSymmetryWandRange.get()).intValue()) {
            return;
        }
        if (!player.func_184812_l_() && SymmetryWandItem.isHoldingBlock(player, block) && BlockHelper.findAndRemoveInInventory(block, player, 1) == 0) {
            return;
        }
        symmetry.process(blockSet);
        BlockPos to = new BlockPos(mirrorPos);
        ArrayList<BlockPos> targets = new ArrayList<BlockPos>();
        targets.add(pos);
        for (BlockPos position : blockSet.keySet()) {
            if (position.equals((Object)pos) || !world.func_226663_a_(block, position, ISelectionContext.func_216374_a((Entity)player))) continue;
            BlockState blockState = (BlockState)blockSet.get(position);
            for (Direction face : Direction.values()) {
                blockState = blockState.func_196956_a(face, world.func_180495_p(position.func_177972_a(face)), (IWorld)world, position, position.func_177972_a(face));
            }
            if (player.func_184812_l_()) {
                world.func_175656_a(position, blockState);
                targets.add(position);
                continue;
            }
            BlockState toReplace = world.func_180495_p(position);
            if (!toReplace.func_185904_a().func_76222_j() || toReplace.func_185887_b((IBlockReader)world, position) == -1.0f || BlockHelper.findAndRemoveInInventory(blockState, player, 1) == 0) continue;
            world.func_175656_a(position, blockState);
            targets.add(position);
        }
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SymmetryEffectPacket(to, targets));
    }

    private static boolean isHoldingBlock(PlayerEntity player, BlockState block) {
        ItemStack itemBlock = BlockHelper.getRequiredItem(block);
        return player.func_184614_ca().func_77969_a(itemBlock) || player.func_184592_cb().func_77969_a(itemBlock);
    }

    public static void remove(World world, ItemStack wand, PlayerEntity player, BlockPos pos) {
        BlockState air = Blocks.field_150350_a.func_176223_P();
        BlockState ogBlock = world.func_180495_p(pos);
        SymmetryWandItem.checkNBT(wand);
        if (!SymmetryWandItem.isEnabled(wand)) {
            return;
        }
        HashMap<BlockPos, BlockState> blockSet = new HashMap<BlockPos, BlockState>();
        blockSet.put(pos, air);
        SymmetryMirror symmetry = SymmetryMirror.fromNBT(wand.func_77978_p().func_74775_l(SYMMETRY));
        Vec3d mirrorPos = symmetry.getPosition();
        Vec3d vec3d = new Vec3d((Vec3i)pos);
        if (mirrorPos.func_72438_d(vec3d) > (double)((Integer)AllConfigs.SERVER.curiosities.maxSymmetryWandRange.get()).intValue()) {
            return;
        }
        symmetry.process(blockSet);
        BlockPos to = new BlockPos(mirrorPos);
        ArrayList<BlockPos> targets = new ArrayList<BlockPos>();
        targets.add(pos);
        for (BlockPos position : blockSet.keySet()) {
            BlockState blockstate;
            if (!player.func_184812_l_() && ogBlock.func_177230_c() != world.func_180495_p(position).func_177230_c() || position.equals((Object)pos) || (blockstate = world.func_180495_p(position)).isAir((IBlockReader)world, position)) continue;
            targets.add(position);
            world.func_217379_c(2001, position, Block.func_196246_j((BlockState)blockstate));
            world.func_180501_a(position, air, 3);
            if (player.func_184812_l_()) continue;
            if (!player.func_184614_ca().func_190926_b()) {
                player.func_184614_ca().func_179548_a(world, blockstate, position, player);
            }
            TileEntity tileentity = blockstate.hasTileEntity() ? world.func_175625_s(position) : null;
            Block.func_220059_a((BlockState)blockstate, (World)world, (BlockPos)pos, (TileEntity)tileentity);
        }
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SymmetryEffectPacket(to, targets));
    }
}

