/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.simibubi.create.foundation.config.AllConfigs;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;

public class ZapperLog {
    private World activeWorld;
    private List<List<Template.BlockInfo>> log = new LinkedList<List<Template.BlockInfo>>();

    public void record(World world, List<BlockPos> positions) {
        if (this.maxLogLength() == 0) {
            return;
        }
        if (world != this.activeWorld) {
            this.log.clear();
        }
        this.activeWorld = world;
        List blocks = positions.stream().map(pos -> {
            TileEntity tileEntity = world.func_175625_s(pos);
            return new Template.BlockInfo(pos, world.func_180495_p(pos), tileEntity == null ? null : tileEntity.serializeNBT());
        }).collect(Collectors.toList());
        this.log.add(0, blocks);
        if (this.maxLogLength() < this.log.size()) {
            this.log.remove(this.log.size() - 1);
        }
    }

    protected Integer maxLogLength() {
        return (Integer)AllConfigs.SERVER.curiosities.zapperUndoLogLength.get();
    }

    public void undo() {
    }

    public void redo() {
    }
}

