/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.transposer.TransposerBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class AttachedLogisticalBlock
extends HorizontalBlock
implements IWrenchable {
    public static final BooleanProperty UPWARD = BooleanProperty.func_177716_a((String)"upward");

    public AttachedLogisticalBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        return ActionResultType.FAIL;
    }

    protected abstract boolean isVertical();

    protected abstract BlockState getVerticalDefaultState();

    protected abstract BlockState getHorizontalDefaultState();

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        if (context.func_196000_l().func_176740_k().func_176722_c()) {
            state = (BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)context.func_196000_l().func_176734_d());
        } else {
            state = this.getVerticalDefaultState();
            state = (BlockState)state.func_206870_a((IProperty)UPWARD, (Comparable)Boolean.valueOf(context.func_196000_l() != Direction.UP));
            state = (BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f());
        }
        return state;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (this.isVertical()) {
            return this.getHorizontalDefaultState().func_177230_c().getPickBlock(state, target, world, pos, player);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction facing = AttachedLogisticalBlock.getBlockFacing(state);
        return this.canAttachToSide(worldIn, pos, facing);
    }

    protected boolean canAttachToSide(IWorldReader worldIn, BlockPos pos, Direction facing) {
        BlockPos neighbourPos = pos.func_177972_a(facing);
        BlockState neighbour = worldIn.func_180495_p(neighbourPos);
        if (neighbour.func_177230_c() instanceof TransposerBlock) {
            return false;
        }
        if (AllBlocks.BELT.has(neighbour)) {
            return BeltBlock.canAccessFromSide(facing, neighbour);
        }
        return !neighbour.func_196954_c((IBlockReader)worldIn, pos).func_197766_b();
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        Direction blockFacing = AttachedLogisticalBlock.getBlockFacing(state);
        if (fromPos.equals((Object)pos.func_177972_a(blockFacing)) && !this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            return;
        }
    }

    public static Direction getBlockFacing(BlockState state) {
        if (AttachedLogisticalBlock.isVertical(state)) {
            return (Boolean)state.func_177229_b((IProperty)UPWARD) != false ? Direction.UP : Direction.DOWN;
        }
        return (Direction)state.func_177229_b((IProperty)field_185512_D);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        if (this.isVertical()) {
            builder.func_206894_a(new IProperty[]{UPWARD});
        }
        super.func_206840_a(builder.func_206894_a(new IProperty[]{field_185512_D}));
    }

    public static boolean isVertical(BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof AttachedLogisticalBlock && ((AttachedLogisticalBlock)state.func_177230_c()).isVertical();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }
}

