/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.extractor;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.logistics.block.AttachedLogisticalBlock;
import com.simibubi.create.content.logistics.block.extractor.ExtractorBlock;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import org.apache.commons.lang3.tuple.Pair;

public class LinkedExtractorBlock
extends ExtractorBlock {
    public LinkedExtractorBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    protected BlockState getVerticalDefaultState() {
        return AllBlocks.VERTICAL_LINKED_EXTRACTOR.getDefaultState();
    }

    @Override
    protected BlockState getHorizontalDefaultState() {
        return AllBlocks.LINKED_EXTRACTOR.getDefaultState();
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.LINKED_EXTRACTOR.create();
    }

    @Override
    protected boolean reactsToRedstone() {
        return false;
    }

    public static Pair<Vec3d, Vec3d> getFrequencySlotPosition(BlockState state) {
        float verticalOffset = state.func_177230_c() instanceof ExtractorBlock ? 4.0f : 6.0f;
        Vec3d first = VecHelper.voxelSpace(11.5, verticalOffset, 14.0);
        Vec3d second = VecHelper.voxelSpace(11.5, 4.0f + verticalOffset, 14.0);
        Vec3d firstUpward = VecHelper.voxelSpace(10.0, 14.0, 11.5);
        Vec3d secondUpward = VecHelper.voxelSpace(6.0, 14.0, 11.5);
        Vec3d firstDownward = VecHelper.voxelSpace(10.0, 2.0, 11.5);
        Vec3d secondDownward = VecHelper.voxelSpace(6.0, 2.0, 11.5);
        float yRot = AngleHelper.horizontalAngle((Direction)state.func_177229_b((IProperty)ExtractorBlock.field_185512_D));
        if (AttachedLogisticalBlock.isVertical(state)) {
            Boolean up = (Boolean)state.func_177229_b((IProperty)AttachedLogisticalBlock.UPWARD);
            first = up != false ? firstUpward : firstDownward;
            second = up != false ? secondUpward : secondDownward;
        }
        first = VecHelper.rotateCentered(first, yRot, Direction.Axis.Y);
        second = VecHelper.rotateCentered(second, yRot, Direction.Axis.Y);
        return Pair.of((Object)first, (Object)second);
    }

    public static Vec3d getFrequencySlotOrientation(BlockState state) {
        boolean vertical = AttachedLogisticalBlock.isVertical(state);
        float horizontalAngle = AngleHelper.horizontalAngle((Direction)state.func_177229_b((IProperty)ExtractorBlock.field_185512_D));
        float xRot = vertical ? (float)((Boolean)state.func_177229_b((IProperty)UPWARD) != false ? 90 : 270) : 0.0f;
        float yRot = vertical ? horizontalAngle + 180.0f : horizontalAngle + 270.0f;
        float zRot = vertical ? 0.0f : 0.0f;
        return new Vec3d((double)xRot, (double)yRot, (double)zRot);
    }

    public static class Vertical
    extends LinkedExtractorBlock {
        public Vertical(Block.Properties properties) {
            super(properties);
        }

        @Override
        protected boolean isVertical() {
            return true;
        }
    }
}

