/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.components.structureMovement.IPortableBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.relays.belt.AllBeltAttachments;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.AttachedLogisticalBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelMovementBehaviour;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class FunnelBlock
extends AttachedLogisticalBlock
implements AllBeltAttachments.IBeltAttachment,
ITE<FunnelTileEntity>,
IPortableBlock {
    public static final BooleanProperty BELT = BooleanProperty.func_177716_a((String)"belt");
    public static final MovementBehaviour MOVEMENT = new FunnelMovementBehaviour();

    public FunnelBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        if (!this.isVertical()) {
            builder.func_206894_a(new IProperty[]{BELT});
        }
        super.func_206840_a(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.FUNNEL.create();
    }

    @Override
    protected boolean isVertical() {
        return false;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            ItemStack remainder = te.tryToInsert(itemEntity.func_92059_d());
            if (remainder.func_190926_b()) {
                itemEntity.func_70106_y();
            }
            if (remainder.func_190916_E() < itemEntity.func_92059_d().func_190916_E()) {
                itemEntity.func_92058_a(remainder);
            }
        });
    }

    @Override
    protected BlockState getVerticalDefaultState() {
        return AllBlocks.VERTICAL_FUNNEL.getDefaultState();
    }

    @Override
    protected BlockState getHorizontalDefaultState() {
        return AllBlocks.FUNNEL.getDefaultState();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !FunnelBlock.isVertical(stateIn)) {
            return (BlockState)stateIn.func_206870_a((IProperty)BELT, (Comparable)Boolean.valueOf(this.isOnBelt(worldIn, currentPos)));
        }
        return stateIn;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        if (!FunnelBlock.isVertical(state)) {
            World world = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            state = (BlockState)state.func_206870_a((IProperty)BELT, (Comparable)Boolean.valueOf(this.isOnBelt((IWorld)world, pos)));
        }
        return state;
    }

    protected boolean isOnBelt(IWorld world, BlockPos pos) {
        return AllBlocks.BELT.has(world.func_180495_p(pos.func_177977_b()));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = FunnelBlock.getBlockFacing(state);
        if (!FunnelBlock.isVertical(state) && ((Boolean)state.func_177229_b((IProperty)BELT)).booleanValue()) {
            return AllShapes.BELT_FUNNEL.get(direction);
        }
        return AllShapes.FUNNEL.get(direction);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.onAttachmentPlaced((IWorld)worldIn, pos, state);
        if (worldIn.field_72995_K) {
            return;
        }
        if (this.isOnBelt((IWorld)worldIn, pos)) {
            BeltTileEntity belt = BeltHelper.getSegmentTE((IWorld)worldIn, pos.func_177977_b());
            if (belt == null) {
                return;
            }
            BeltTileEntity controllerBelt = belt.getControllerTE();
            if (controllerBelt == null) {
                return;
            }
            if (controllerBelt.getInventory() == null) {
                return;
            }
            controllerBelt.getInventory().forEachWithin((float)belt.index + 0.5f, 0.55f, transportedItemStack -> {
                controllerBelt.getInventory().eject((TransportedItemStack)transportedItemStack);
                return Collections.emptyList();
            });
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.onAttachmentRemoved((IWorld)worldIn, pos, state);
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            TileEntityBehaviour.destroy((ILightReader)worldIn, pos, FilteringBehaviour.TYPE);
            worldIn.func_175713_t(pos);
        }
    }

    @Override
    public List<BlockPos> getPotentialAttachmentPositions(IWorld world, BlockPos pos, BlockState beltState) {
        return Arrays.asList(pos.func_177984_a());
    }

    @Override
    public BlockPos getBeltPositionForAttachment(IWorld world, BlockPos pos, BlockState state) {
        return pos.func_177977_b();
    }

    @Override
    public boolean startProcessingItem(BeltTileEntity te, TransportedItemStack transported, AllBeltAttachments.BeltAttachmentState state) {
        return this.process(te, transported, state);
    }

    @Override
    public boolean isAttachedCorrectly(IWorld world, BlockPos attachmentPos, BlockPos beltPos, BlockState attachmentState, BlockState beltState) {
        return !FunnelBlock.isVertical(attachmentState);
    }

    @Override
    public boolean processItem(BeltTileEntity te, TransportedItemStack transported, AllBeltAttachments.BeltAttachmentState state) {
        Direction movementFacing = te.getMovementFacing();
        if (movementFacing != te.func_145831_w().func_180495_p(state.attachmentPos).func_177229_b((IProperty)field_185512_D)) {
            return false;
        }
        return this.process(te, transported, state);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (hit.func_216354_b() == FunnelBlock.getBlockFacing(state).func_176734_d()) {
            if (!worldIn.field_72995_K) {
                this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
                    ItemStack heldItem = player.func_184586_b(handIn).func_77946_l();
                    ItemStack remainder = te.tryToInsert(heldItem);
                    if (!ItemStack.func_77989_b((ItemStack)remainder, (ItemStack)heldItem)) {
                        player.func_184611_a(handIn, remainder);
                    }
                });
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean process(BeltTileEntity belt, TransportedItemStack transported, AllBeltAttachments.BeltAttachmentState state) {
        ItemStack stack;
        TileEntity te = belt.func_145831_w().func_175625_s(state.attachmentPos);
        if (!(te instanceof FunnelTileEntity)) {
            return false;
        }
        FunnelTileEntity funnel = (FunnelTileEntity)te;
        transported.stack = stack = funnel.tryToInsert(transported.stack);
        return true;
    }

    @Override
    public MovementBehaviour getMovementBehaviour() {
        return MOVEMENT;
    }

    @Override
    public Class<FunnelTileEntity> getTileEntityClass() {
        return FunnelTileEntity.class;
    }

    public static class Vertical
    extends FunnelBlock {
        public Vertical(Block.Properties properties) {
            super(properties);
        }

        @Override
        protected boolean isVertical() {
            return true;
        }
    }
}

